/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.darkhax.bookshelf.util.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.subaraki.telepads.Telepads;

public class TeleportUtility {
    private static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean forceRecreate) {
        EnderTeleportEvent etpEvent;
        if (entity == null || entity.field_70128_L || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityLivingBase && MinecraftForge.EVENT_BUS.post((Event)(etpEvent = new EnderTeleportEvent((EntityLivingBase)entity, x, y, z, 0.0f)))) {
            return null;
        }
        if (!entity.field_70170_p.field_72995_K && entity.field_70170_p instanceof WorldServer) {
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer worldServerDst = minecraftserver.func_71218_a(dimDst);
            if (worldServerDst == null) {
                Telepads.printDebugMessage("teleportEntity(): worldServerDst == null");
                return null;
            }
            IChunkProvider chunkProvider = worldServerDst.func_72863_F();
            if (chunkProvider == null) {
                return null;
            }
            if (!chunkProvider.func_73149_a((int)x >> 4, (int)z >> 4)) {
                chunkProvider.func_73158_c((int)x >> 4, (int)z >> 4);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_70657_f(0.0f);
                    ((EntityLiving)entity).func_70661_as().func_75499_g();
                }
                if (entity.field_71093_bK != dimDst || entity.field_70170_p instanceof WorldServer && entity.field_70170_p != worldServerDst) {
                    entity = TeleportUtility.transferEntityToDimension(entity, dimDst, x, y, z);
                } else if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_70634_a(x, y, z);
                } else if (forceRecreate) {
                    entity = TeleportUtility.reCreateEntity(entity, x, y, z);
                } else if (entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70634_a(x, y, z);
                } else {
                    entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
                }
            }
        }
        return entity;
    }

    public static Entity reCreateEntity(Entity entitySrc, double x, double y, double z) {
        if (entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(entitySrc.field_71093_bK);
        if (worldServerDst == null) {
            Telepads.printDebugMessage("reCreateEntity(): worldServerDst == null");
            return null;
        }
        Entity entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst);
        if (entityDst == null) {
            return null;
        }
        entitySrc.field_70170_p.func_72900_e(entitySrc);
        entitySrc.field_70128_L = false;
        entityDst.func_82141_a(entitySrc, true);
        if (entityDst instanceof EntityLivingBase) {
            ((EntityLivingBase)entityDst).func_70634_a(x, y, z);
        } else {
            entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        }
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_82742_i();
        entitySrc.field_70128_L = true;
        return entityDst;
    }

    public static Entity transferEntityToDimension(Entity entitySrc, int dimDst, double x, double y, double z) {
        if (entitySrc == null || entitySrc.field_70128_L || entitySrc.field_71093_bK == dimDst || entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        if (entitySrc instanceof EntityPlayerMP) {
            return TeleportUtility.transferPlayerToDimension((EntityPlayerMP)entitySrc, dimDst, x, y, z);
        }
        WorldServer worldServerSrc = MinecraftServer.func_71276_C().func_71218_a(entitySrc.field_71093_bK);
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            Telepads.printDebugMessage("transferEntityToDimension(): worldServer[Src|Dst] == null");
            return null;
        }
        entitySrc.func_70078_a((Entity)null);
        if (entitySrc.field_70153_n != null) {
            entitySrc.field_70153_n.func_70078_a((Entity)null);
        }
        entitySrc.field_71093_bK = dimDst;
        Entity entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst);
        if (entityDst == null) {
            return null;
        }
        entityDst.func_82141_a(entitySrc, true);
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_72866_a(entityDst, false);
        entityDst.func_70029_a((World)worldServerDst);
        entitySrc.field_70128_L = true;
        worldServerSrc.func_82742_i();
        worldServerDst.func_82742_i();
        return entityDst;
    }

    public static EntityPlayerMP transferPlayerToDimension(EntityPlayerMP player, int dimDst, Position pos) {
        return TeleportUtility.transferPlayerToDimension(player, dimDst, pos.getX(), pos.getY(), pos.getZ());
    }

    public static EntityPlayerMP transferPlayerToDimension(EntityPlayerMP player, int dimDst, double x, double y, double z) {
        if (player == null || player.field_70128_L || player.field_71093_bK == dimDst || player.field_70170_p.field_72995_K) {
            return null;
        }
        PlayerEvent.PlayerChangedDimensionEvent pcdEvent = new PlayerEvent.PlayerChangedDimensionEvent((EntityPlayer)player, player.field_71093_bK, dimDst);
        if (FMLCommonHandler.instance().bus().post((Event)pcdEvent)) {
            return null;
        }
        int dimSrc = player.field_71093_bK;
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
        ServerConfigurationManager serverCM = player.field_71133_b.func_71203_ab();
        WorldServer worldServerSrc = MinecraftServer.func_71276_C().func_71218_a(dimSrc);
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            Telepads.printDebugMessage("transferPlayerToDimension(): worldServer[Src|Dst] == null");
            return null;
        }
        player.field_71093_bK = dimDst;
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldServerSrc.func_72900_e((Entity)player);
        player.field_70128_L = false;
        player.func_70078_a((Entity)null);
        if (player.field_70153_n != null) {
            player.field_70153_n.func_70078_a((Entity)null);
        }
        worldServerDst.func_72838_d((Entity)player);
        worldServerDst.func_72866_a((Entity)player, false);
        player.func_70029_a((World)worldServerDst);
        serverCM.func_72375_a(player, worldServerSrc);
        player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldServerDst);
        player.field_71133_b.func_71203_ab().func_72354_b(player, worldServerDst);
        player.field_71133_b.func_71203_ab().func_72385_f(player);
        player.func_71023_q(0);
        player.func_71118_n();
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, dimSrc, dimDst);
        return player;
    }
}

