/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.concurrent.thread;

import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.concurrent.batch.Batcher;
import com.terraforged.engine.concurrent.batch.ForkJoinBatcher;
import com.terraforged.engine.concurrent.pool.ObjectPool;
import com.terraforged.engine.concurrent.thread.ThreadPool;
import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.engine.concurrent.thread.WorkerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

public class ForkJoinThreadPool
implements ThreadPool {
    private final int size;
    private final boolean keepAlive;
    private final ForkJoinPool executor;
    private final ObjectPool<Batcher> batchers;

    public ForkJoinThreadPool(int size, boolean keepAlive) {
        this.size = size;
        this.keepAlive = keepAlive;
        this.executor = new ForkJoinPool(size, new WorkerFactory.ForkJoin("TF-Fork"), null, true);
        this.batchers = new ObjectPool<Batcher>(10, () -> new ForkJoinBatcher(this.executor));
    }

    @Override
    public boolean supportsBatching() {
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.executor.submit(runnable);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.executor.submit((Callable)callable);
    }

    @Override
    public boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        ThreadPools.shutdown(this);
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    @Override
    public Resource<Batcher> batcher() {
        return this.batchers.get();
    }
}

