/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.concurrent.thread;

import com.terraforged.engine.concurrent.thread.BatchingThreadPool;
import com.terraforged.engine.concurrent.thread.ForkJoinThreadPool;
import com.terraforged.engine.concurrent.thread.SimpleThreadFactory;
import com.terraforged.engine.concurrent.thread.SingleThreadPool;
import com.terraforged.engine.concurrent.thread.ThreadPool;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ThreadPools {
    private static final Object lock = new Object();
    private static final ThreadPool util = ThreadPools.createInitialPool(3);
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new SimpleThreadFactory("TF-Scheduler"));
    private static WeakReference<ThreadPool> instance = new WeakReference<Object>(null);

    public static ThreadPool getUtilPool() {
        return util;
    }

    public static ThreadPool singleThreaded() {
        return new SingleThreadPool();
    }

    private static ThreadPool createInitialPool(int poolSize) {
        if (poolSize <= 2) {
            return new SingleThreadPool();
        }
        if (poolSize < 4) {
            return new ForkJoinThreadPool(poolSize, true);
        }
        return BatchingThreadPool.of(poolSize, true);
    }

    public static ThreadPool createDefault() {
        return ThreadPools.create(ThreadPools.defaultPoolSize());
    }

    public static ThreadPool create(int poolSize) {
        return ThreadPools.create(poolSize, poolSize < 4);
    }

    public static ThreadPool create(int poolSize, boolean batching) {
        return ThreadPools.create(poolSize, batching, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool create(int poolSize, boolean batching, boolean keepAlive) {
        Object object = lock;
        synchronized (object) {
            ThreadPool current = (ThreadPool)instance.get();
            if (current != null && !current.keepAlive()) {
                if (poolSize == current.size() && current.supportsBatching() == batching) {
                    return current;
                }
                current.shutdown();
            }
        }
        if (poolSize <= 2) {
            return ThreadPools.setAndGet(new SingleThreadPool());
        }
        if (poolSize < 4 || !batching) {
            return ThreadPools.setAndGet(new ForkJoinThreadPool(poolSize, keepAlive));
        }
        return ThreadPools.setAndGet(BatchingThreadPool.of(poolSize, keepAlive));
    }

    public static int defaultPoolSize() {
        int processors = Runtime.getRuntime().availableProcessors();
        return Math.max(1, processors);
    }

    public static void scheduleDelayed(Runnable runnable, long delayMS) {
        scheduler.schedule(runnable, delayMS, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleRepeat(Runnable runnable, long intervalMS) {
        return scheduler.scheduleAtFixedRate(runnable, intervalMS, intervalMS, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(ThreadPool threadPool) {
        Object object = lock;
        synchronized (object) {
            if (threadPool == instance.get()) {
                instance = new WeakReference<Object>(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        scheduler.shutdownNow();
        ThreadPools.shutdownNow(util);
        Object object = lock;
        synchronized (object) {
            ThreadPools.shutdownNow((ThreadPool)instance.get());
            instance.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPool setAndGet(ThreadPool threadPool) {
        if (!threadPool.keepAlive()) {
            Object object = lock;
            synchronized (object) {
                instance = new WeakReference<ThreadPool>(threadPool);
            }
        }
        return threadPool;
    }

    private static void shutdownNow(ThreadPool pool) {
        if (pool != null) {
            pool.shutdownNow();
        }
    }
}

