/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.tile.api;

import com.terraforged.engine.concurrent.Disposable;
import com.terraforged.engine.tile.Tile;
import com.terraforged.engine.tile.chunk.ChunkReader;

public interface TileProvider
extends Disposable.Listener<Tile> {
    public boolean supportsQueuing();

    public int chunkToRegion(int var1);

    public Tile getTile(long var1);

    public Tile getIfPresent(long var1);

    default public Tile getTile(int regionX, int regionZ) {
        return this.getTile(Tile.getRegionId(regionX, regionZ));
    }

    default public Tile getIfPresent(int regionX, int regionZ) {
        return this.getIfPresent(Tile.getRegionId(regionX, regionZ));
    }

    default public ChunkReader getChunk(int chunkX, int chunkZ) {
        int regionX = this.chunkToRegion(chunkX);
        int regionZ = this.chunkToRegion(chunkZ);
        return this.getTile(regionX, regionZ).getChunk(chunkX, chunkZ);
    }
}

