/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.tile.gen;

import com.terraforged.engine.concurrent.cache.Cache;
import com.terraforged.engine.concurrent.cache.CacheEntry;
import com.terraforged.engine.tile.Tile;
import com.terraforged.engine.tile.api.TileFactory;
import com.terraforged.engine.tile.api.TileProvider;
import com.terraforged.engine.tile.chunk.ChunkReader;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;

public class TileCache
implements TileProvider {
    private final boolean queuing;
    private final TileFactory generator;
    private final Cache<CacheEntry<Tile>> cache;
    private final LongFunction<CacheEntry<Tile>> syncGetter;
    private final LongFunction<CacheEntry<Tile>> asyncGetter;

    public TileCache(boolean queueNeighbours, TileFactory generator) {
        this.generator = generator;
        this.syncGetter = this.syncGetter();
        this.asyncGetter = this.asyncGetter();
        this.queuing = queueNeighbours;
        this.cache = new Cache("TileCache", 256, 60L, 20L, TimeUnit.SECONDS);
        generator.setListener(this);
    }

    @Override
    public void onDispose(Tile tile) {
        this.cache.remove(tile.getRegionId());
    }

    @Override
    public boolean supportsQueuing() {
        return this.generator.supportsAsync();
    }

    @Override
    public int chunkToRegion(int coord) {
        return this.generator.chunkToRegion(coord);
    }

    @Override
    public Tile getTile(long id) {
        return this.cache.computeIfAbsent(id, this.syncGetter).get();
    }

    @Override
    public Tile getIfPresent(long id) {
        CacheEntry<Tile> entry = this.cache.get(id);
        if (entry == null || !entry.isDone()) {
            return null;
        }
        return entry.get();
    }

    @Override
    public ChunkReader getChunk(int chunkX, int chunkZ) {
        int regionX = this.generator.chunkToRegion(chunkX);
        int regionZ = this.generator.chunkToRegion(chunkZ);
        long regionId = Tile.getRegionId(regionX, regionZ);
        return this.cache.map(regionId, this.syncGetter, entry -> ((Tile)entry.get()).getChunk(chunkX, chunkZ));
    }

    @Override
    public Tile getTile(int regionX, int regionZ) {
        Tile tile = this.getEntry(regionX, regionZ).get();
        if (this.queuing) {
            this.queueNeighbours(regionX, regionZ);
        }
        return tile;
    }

    @Override
    public Tile getIfPresent(int regionX, int regionZ) {
        CacheEntry<Tile> entry = this.cache.get(Tile.getRegionId(regionX, regionZ));
        if (entry == null || !entry.isDone()) {
            return null;
        }
        return entry.get();
    }

    public CacheEntry<Tile> getEntry(int regionX, int regionZ) {
        return this.cache.computeIfAbsent(Tile.getRegionId(regionX, regionZ), this.syncGetter);
    }

    public CacheEntry<Tile> queueRegion(int regionX, int regionZ) {
        return this.cache.computeIfAbsent(Tile.getRegionId(regionX, regionZ), this.asyncGetter);
    }

    private LongFunction<CacheEntry<Tile>> syncGetter() {
        return id -> this.generator.getSync((int)id, (int)(id >> 32));
    }

    private LongFunction<CacheEntry<Tile>> asyncGetter() {
        return id -> this.generator.getAsync((int)id, (int)(id >> 32));
    }

    private void queueNeighbours(int rx, int rz) {
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = 0; dx <= 1; ++dx) {
                if (dx == 0 && dz == 0) continue;
                this.queueRegion(rx + dx, rz + dz);
            }
        }
    }
}

