/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.tile.gen;

import com.terraforged.engine.concurrent.Disposable;
import com.terraforged.engine.concurrent.cache.CacheEntry;
import com.terraforged.engine.concurrent.thread.ThreadPool;
import com.terraforged.engine.tile.Tile;
import com.terraforged.engine.tile.api.TileFactory;
import com.terraforged.engine.tile.gen.CallableTile;
import com.terraforged.engine.tile.gen.CallableZoomTile;
import com.terraforged.engine.tile.gen.TileGeneratorBatched;
import com.terraforged.engine.tile.gen.TileResources;
import com.terraforged.engine.world.WorldGenerator;
import com.terraforged.engine.world.WorldGeneratorFactory;

public class TileGenerator
implements TileFactory {
    protected final int factor;
    protected final int border;
    protected final int batchSize;
    protected final ThreadPool threadPool;
    protected final WorldGenerator generator;
    private final TileResources resources = new TileResources();
    private Disposable.Listener<Tile> listener = r -> {};

    protected TileGenerator(Builder builder) {
        this.factor = builder.factor;
        this.border = builder.border;
        this.batchSize = builder.batchSize;
        this.threadPool = builder.threadPool;
        this.generator = builder.factory.get();
    }

    public WorldGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public void setListener(Disposable.Listener<Tile> listener) {
        this.listener = listener;
    }

    @Override
    public boolean supportsAsync() {
        return this.threadPool.size() > 1;
    }

    @Override
    public int chunkToRegion(int i) {
        return i >> this.factor;
    }

    @Override
    public CacheEntry<Tile> getSync(int regionX, int regionZ) {
        return CacheEntry.supply(new CallableTile(regionX, regionZ, this));
    }

    @Override
    public CacheEntry<Tile> getSync(int regionX, int regionZ, float zoom, boolean filter) {
        return CacheEntry.supply(new CallableZoomTile(regionX, regionZ, zoom, filter, this));
    }

    @Override
    public CacheEntry<Tile> getAsync(int regionX, int regionZ) {
        return CacheEntry.supplyAsync(new CallableTile(regionX, regionZ, this), this.threadPool);
    }

    @Override
    public CacheEntry<Tile> getAsync(float centerX, float centerZ, float zoom, boolean filter) {
        return CacheEntry.supplyAsync(new CallableZoomTile(centerX, centerZ, zoom, filter, this), this.threadPool);
    }

    public Tile generateRegion(int regionX, int regionZ) {
        Tile tile = this.createEmptyRegion(regionX, regionZ);
        tile.generate(this.generator.getHeightmap());
        this.postProcess(tile);
        return tile;
    }

    public Tile generateRegion(float centerX, float centerZ, float zoom, boolean filter) {
        Tile tile = this.createEmptyRegion(0, 0);
        tile.generate(this.generator.getHeightmap(), centerX, centerZ, zoom);
        this.postProcess(tile, filter);
        return tile;
    }

    public Tile createEmptyRegion(int regionX, int regionZ) {
        return new Tile(regionX, regionZ, this.factor, this.border, this.resources, this.listener);
    }

    protected void postProcess(Tile tile) {
        this.generator.getFilters().apply(tile, true);
    }

    protected void postProcess(Tile tile, boolean filter) {
        this.generator.getFilters().apply(tile, filter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int factor = 0;
        private int border = 0;
        private int batchSize = 0;
        private ThreadPool threadPool;
        private WorldGeneratorFactory factory;

        public Builder size(int factor, int border) {
            return this.factor(factor).border(border);
        }

        public Builder factor(int factor) {
            this.factor = factor;
            return this;
        }

        public Builder border(int border) {
            this.border = border;
            return this;
        }

        public Builder pool(ThreadPool threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public Builder factory(WorldGeneratorFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder batch(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public TileGenerator build() {
            if (this.threadPool.supportsBatching() && this.batchSize > 1) {
                return new TileGeneratorBatched(this);
            }
            return new TileGenerator(this);
        }
    }
}

