/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.context;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.engine.world.biome.map.BiomeContext;
import com.terraforged.mod.biome.context.BiomeDefaults;
import com.terraforged.mod.biome.context.BiomeProperties;
import com.terraforged.mod.biome.context.TFDefaultBiomes;
import com.terraforged.mod.featuremanager.util.RegistryInstance;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;

public class TFBiomeContext
implements BiomeContext<RegistryKey<Biome>> {
    public static final Codec<TFBiomeContext> CODEC = Codecs.create(TFBiomeContext::encodeBiomeContext, TFBiomeContext::decodeBiomeContext);
    private final BiomeDefaults defaults;
    private final BiomeProperties properties;
    public final RegistryInstance<Biome> biomes;

    public TFBiomeContext(DynamicRegistries.Impl registries) {
        this((Registry<Biome>)registries.func_243612_b(Registry.field_239720_u_));
    }

    public TFBiomeContext(Registry<Biome> biomes) {
        this.biomes = new RegistryInstance<Biome>(biomes);
        this.defaults = new BiomeDefaults(this);
        this.properties = new BiomeProperties(this);
    }

    @Override
    public int getId(RegistryKey<Biome> key) {
        return this.biomes.getId(key);
    }

    @Override
    public RegistryKey<Biome> getValue(int id) {
        return this.biomes.getKey(this.biomes.get(id));
    }

    @Override
    public String getName(int id) {
        return this.biomes.getName(id);
    }

    @Override
    public IntSet getRiverOverrides() {
        IntOpenHashSet set = new IntOpenHashSet();
        for (Biome biome : this.biomes) {
            if (!TFDefaultBiomes.overridesRiver(biome)) continue;
            set.add(this.biomes.getId(biome));
        }
        return set;
    }

    @Override
    public BiomeContext.Defaults<RegistryKey<Biome>> getDefaults() {
        return this.defaults;
    }

    @Override
    public BiomeContext.Properties<RegistryKey<Biome>> getProperties() {
        return this.properties;
    }

    private static <T> TFBiomeContext decodeBiomeContext(Dynamic<T> dynamic) {
        return new TFBiomeContext((Registry<Biome>)((Registry)Codecs.decodeAndGet(RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).codec(), dynamic)));
    }

    private static <T> Dynamic<T> encodeBiomeContext(TFBiomeContext context, DynamicOps<T> ops) {
        return new Dynamic(ops, Codecs.encodeAndGet(RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).codec(), context.biomes.getRegistry(), ops));
    }

    public static TFBiomeContext dynamic() {
        return new TFBiomeContext(DynamicRegistries.func_239770_b_());
    }
}

