/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.analyser.BiomeAnalyser;
import com.terraforged.mod.config.ConfigManager;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BiomeWeights
implements IntUnaryOperator {
    private final int standardWeight;
    private final int forestWeight;
    private final int rareWeight;
    private final TFBiomeContext context;
    private final Object2IntMap<String> biomes = new Object2IntOpenHashMap();

    public BiomeWeights(TFBiomeContext context) {
        this(10, 5, 2, context);
    }

    public BiomeWeights(int standard, int forest, int rare, TFBiomeContext context) {
        this.standardWeight = standard;
        this.forestWeight = forest;
        this.rareWeight = rare;
        this.context = context;
        Set<String> validBiomes = BiomeAnalyser.getOverworldBiomesSet(context, context.biomes::getName);
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            if (entries == null) continue;
            for (BiomeManager.BiomeEntry entry : entries) {
                Biome biome = context.biomes.get((RegistryKey<Biome>)entry.getKey());
                String name = context.biomes.getName(biome);
                if (!validBiomes.contains(name)) continue;
                this.biomes.put((Object)name.toString(), entry.field_76292_a);
            }
        }
        this.readWeights(validBiomes);
    }

    @Override
    public int applyAsInt(int biome) {
        return this.getWeight(biome);
    }

    public int getWeight(int biome) {
        String name = this.context.getName(biome);
        Integer value = this.biomes.get((Object)name);
        if (value != null) {
            return value;
        }
        if (BiomeDictionary.getTypes(this.context.getValue(biome)).contains(BiomeDictionary.Type.RARE)) {
            return this.rareWeight;
        }
        if (this.context.biomes.get(biome).func_201856_r() == Biome.Category.FOREST) {
            return this.forestWeight;
        }
        return this.standardWeight;
    }

    public void forEachEntry(BiConsumer<String, Integer> consumer) {
        this.biomes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> consumer.accept((String)e.getKey(), (Integer)e.getValue()));
    }

    public void forEachUnregistered(BiConsumer<String, Integer> consumer) {
        for (Biome biome : this.context.biomes) {
            int id = this.context.biomes.getId(biome);
            String name = this.context.getName(id);
            if (this.biomes.containsKey((Object)name)) continue;
            int weight = this.getWeight(id);
            consumer.accept(name, weight);
        }
    }

    private void readWeights(Set<String> validBiomes) {
        CommentedFileConfig config = ConfigManager.BIOME_WEIGHTS.get();
        for (String key : config.valueMap().keySet()) {
            if (!validBiomes.contains(key)) continue;
            int weight = Math.max(0, config.getInt(key));
            this.biomes.put((Object)key, weight);
            Log.debug("Loaded custom biome weight: {}={}", key, weight);
        }
    }
}

