/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.engine.world.biome.map.BiomeMap;
import com.terraforged.engine.world.heightmap.WorldLookup;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.BiomeCache;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.biome.provider.BiomeModifierManager;
import com.terraforged.mod.biome.provider.BiomeResources;
import com.terraforged.mod.biome.provider.analyser.BiomeAnalyser;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.noise.util.NoiseUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;

public class TFBiomeProvider
extends BiomeProvider {
    public static final Codec<TFBiomeProvider> CODEC = Codecs.create(TFBiomeProvider::encode, TFBiomeProvider::decode);
    private final long seed;
    private final TerraContext context;
    private final BiomeCache biomeCache;
    private final LazySupplier<BiomeResources> resources;
    private final float biomeSearchModifier;

    public TFBiomeProvider(TerraContext context) {
        super(BiomeAnalyser.getOverworldBiomesList(context.biomeContext));
        this.context = context;
        this.seed = context.terraSettings.world.seed;
        this.biomeCache = new BiomeCache(this);
        this.resources = LazySupplier.factory(context.copy(), BiomeResources::new);
        this.biomeSearchModifier = BiomeHelper.getBiomeSizeSearchModifier(context.settings.climate);
    }

    protected Codec<TFBiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        try (Resource<Cell> resource = Cell.pooled();){
            Cell cell = resource.get().reset();
            Biome biome = this.getNoiseBiome(cell, x, z);
            return biome;
        }
    }

    public TFBiomeProvider withSeed(long seed) {
        Log.debug("Creating seeded biome provider: {}", seed);
        TerraSettings settings = this.context.terraSettings;
        settings.world.seed = seed;
        return new TFBiomeProvider(new TerraContext(settings, this.context.biomeContext));
    }

    public Set<Biome> func_225530_a_(int centerX, int centerY, int centerZ, int radius) {
        radius = Math.max(8, NoiseUtil.round(this.biomeSearchModifier * (float)radius));
        int minX = centerX - radius;
        int minZ = centerZ - radius;
        int maxX = centerX + radius;
        int maxZ = centerZ + radius;
        HashSet set = Sets.newHashSet();
        Cell cell = new Cell();
        for (int z = minZ; z <= maxZ; z += 4) {
            for (int x = minX; x <= maxX; x += 4) {
                Biome biome = this.lookupBiome(cell, x, z, false);
                set.add(biome);
            }
        }
        return set;
    }

    @Nullable
    public BlockPos func_230321_a_(int centerX, int centerY, int centerZ, int radius, int increment, Predicate<Biome> biomes, Random random, boolean centerOutSearch) {
        int startRadius;
        int biomeRadius = radius >> 2;
        int biomeCenterX = centerX >> 2;
        int biomeCenterZ = centerZ >> 2;
        Cell cell = new Cell();
        BlockPos.Mutable pos = null;
        int count = 0;
        for (int r = startRadius = centerOutSearch ? 0 : biomeRadius; r < biomeRadius; r += increment) {
            for (int dz = -r; dz <= r; ++dz) {
                boolean onRadiusZ = Math.abs(dz) == r;
                for (int dx = -r; dx <= r; ++dx) {
                    int biomeZ;
                    int z;
                    int biomeX;
                    int x;
                    Biome biome;
                    if (centerOutSearch) {
                        boolean onRadiusX;
                        boolean bl = onRadiusX = Math.abs(dx) == r;
                        if (!onRadiusX && !onRadiusZ) continue;
                    }
                    if (!biomes.test(biome = this.lookupBiome(cell, x = (biomeX = biomeCenterX + dx) << 2, z = (biomeZ = biomeCenterZ + dz) << 2, false))) continue;
                    if (centerOutSearch) {
                        return new BlockPos(x, centerY, z);
                    }
                    if (pos == null) {
                        pos = new BlockPos.Mutable(x, centerY, z);
                    } else if (random.nextInt(count + 1) == 0) {
                        pos.func_181079_c(x, centerY, z);
                    }
                    ++count;
                }
            }
        }
        return pos;
    }

    public WorldLookup getWorldLookup() {
        return this.getResources().worldLookup;
    }

    public TerraContext getContext() {
        return this.context;
    }

    public TerraSettings getSettings() {
        return this.context.terraSettings;
    }

    public BiomeModifierManager getModifierManager() {
        return this.getResources().modifierManager;
    }

    public Biome getNoiseBiome(Cell cell, int x, int z) {
        int biome = this.biomeCache.getNoiseBiome(cell, x, z, false);
        return this.getBiomeFromId(biome);
    }

    public Biome lookupBiome(Cell cell, int x, int z, boolean load) {
        int biomeId = this.biomeCache.tryGetBiome(cell, x, z, load);
        if (!BiomeMap.isValid(biomeId)) {
            biomeId = this.computeBiome(cell, x, z, load);
            this.biomeCache.tryStoreBiome(x, z, biomeId);
        }
        return this.getBiomeFromId(biomeId);
    }

    public Biome readBiome(Cell cell, int x, int z) {
        int biome = this.getBiomeId(cell, x, z);
        this.biomeCache.tryStoreBiome(x, z, biome);
        return this.getBiomeFromId(biome);
    }

    protected int computeBiome(Cell cell, int x, int z, boolean load) {
        this.getWorldLookup().applyCell(cell, x, z, load);
        return this.getBiomeId(cell, x, z);
    }

    private Biome getBiomeFromId(int biome) {
        Biome result = this.context.biomeContext.biomes.get(biome);
        Preconditions.checkNotNull((Object)result, (Object)"NULL BIOME D:");
        return result;
    }

    private int getBiomeId(Cell cell, int x, int z) {
        int modified;
        BiomeResources resources = this.getResources();
        int biome = resources.biomemap.provideBiome(cell, this.context.levels);
        if (resources.modifierManager.hasModifiers(cell, this.context.levels) && BiomeMap.isValid(modified = resources.modifierManager.modify(biome, cell, x, z))) {
            biome = modified;
        }
        return biome;
    }

    public boolean canSpawnAt(Cell cell) {
        return !cell.terrain.isSubmerged();
    }

    private BiomeResources getResources() {
        return (BiomeResources)this.resources.get();
    }

    private static <T> Dynamic<T> encode(TFBiomeProvider provider, DynamicOps<T> ops) {
        T seed = Codecs.encodeAndGet(Codec.LONG, provider.seed, ops);
        T context = Codecs.encodeAndGet(TFBiomeContext.CODEC, provider.getContext().biomeContext, ops);
        T settings = Codecs.encodeAndGet(TerraSettings.CODEC, provider.getContext().terraSettings, ops);
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("seed"), seed, (Object)ops.createString("game_data"), context, (Object)ops.createString("generator_settings"), settings)));
    }

    private static <T> TFBiomeProvider decode(Dynamic<T> dynamic) {
        long seed = (Long)Codecs.decodeAndGet(Codec.LONG, dynamic.get("seed"));
        TFBiomeContext gameContext = Codecs.decodeAndGet(TFBiomeContext.CODEC, dynamic.get("game_data"));
        TerraSettings settings = Codecs.decodeAndGet(TerraSettings.CODEC, dynamic.get("generator_settings"));
        settings.world.seed = seed;
        return new TFBiomeProvider(new TerraContext(settings, gameContext));
    }
}

