/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.cache.CacheManager;
import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.engine.tile.Tile;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.engine.tile.gen.TileCache;
import com.terraforged.mod.Log;
import com.terraforged.mod.api.biome.surface.SurfaceManager;
import com.terraforged.mod.api.chunk.column.BlockColumn;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.api.material.layer.LayerManager;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.GeneratorResources;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.column.ColumnResource;
import com.terraforged.mod.chunk.generator.BaseGenerator;
import com.terraforged.mod.chunk.generator.BiomeGenerator;
import com.terraforged.mod.chunk.generator.FeatureGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.generator.MobGenerator;
import com.terraforged.mod.chunk.generator.StrongholdGenerator;
import com.terraforged.mod.chunk.generator.StructureGenerator;
import com.terraforged.mod.chunk.generator.SurfaceGenerator;
import com.terraforged.mod.chunk.generator.TerrainCarver;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.mod.featuremanager.util.codec.DecoderFunc;
import com.terraforged.mod.featuremanager.util.codec.EncoderFunc;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoManager;
import com.terraforged.mod.profiler.Profiler;
import com.terraforged.mod.profiler.Section;
import com.terraforged.mod.profiler.crash.CrashHandler;
import com.terraforged.mod.profiler.crash.WorldGenException;
import com.terraforged.mod.profiler.watchdog.UncheckedException;
import com.terraforged.mod.structure.StructureLocator;
import com.terraforged.mod.structure.StructureSettingsCache;
import com.terraforged.mod.util.DataUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;

public class TFChunkGenerator
extends ChunkGenerator {
    public static final Codec<TFChunkGenerator> CODEC = TFChunkGenerator.codec(TFChunkGenerator::new);
    private final long seed;
    private final TerraContext context;
    private final TFBiomeProvider biomeProvider;
    private final Supplier<DimensionSettings> settings;
    private final DimensionStructuresSettings structuresSettings;
    private final Generator.Mobs mobGenerator;
    private final Generator.Biomes biomeGenerator;
    private final Generator.Carvers terrainCarver;
    private final Generator.Terrain terrainGenerator;
    private final Generator.Surfaces surfaceGenerator;
    private final Generator.Features featureGenerator;
    private final Generator.Structures structureGenerator;
    private final Generator.Strongholds strongholdGenerator;
    private final Supplier<GeneratorResources> resources;
    private final ThreadLocal<Cell> localCellResource = ThreadLocal.withInitial(Cell::new);

    public TFChunkGenerator(TFBiomeProvider biomeProvider, Supplier<DimensionSettings> settings) {
        super((BiomeProvider)biomeProvider, biomeProvider.getSettings().structures.apply(settings));
        CacheManager.get().clear();
        StructureSettingsCache.clear();
        TerraContext context = biomeProvider.getContext();
        this.seed = context.terraSettings.world.seed;
        this.context = context;
        this.settings = settings;
        this.structuresSettings = context.terraSettings.structures.apply(settings);
        this.biomeProvider = biomeProvider;
        this.mobGenerator = new MobGenerator(this);
        this.biomeGenerator = new BiomeGenerator(this);
        this.terrainCarver = new TerrainCarver(this);
        this.terrainGenerator = new BaseGenerator(this);
        this.surfaceGenerator = new SurfaceGenerator(this);
        this.featureGenerator = new FeatureGenerator(this);
        this.structureGenerator = new StructureGenerator(this, this.structuresSettings);
        this.strongholdGenerator = new StrongholdGenerator(this.seed, biomeProvider);
        this.resources = LazySupplier.factory(context.split(746382634), GeneratorResources.factory(this));
        Profiler.reset();
        Log.debug("Created TerraForged chunk-generator with settings {}", DataUtils.toJson(context.terraSettings));
    }

    public final long getSeed() {
        return this.seed;
    }

    public final Supplier<DimensionSettings> getDimensionSettings() {
        return this.settings;
    }

    public final DimensionStructuresSettings func_235957_b_() {
        return StructureSettingsCache.get(this.structuresSettings);
    }

    protected final Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public final ChunkGenerator func_230349_a_(long seed) {
        Log.debug("Creating seeded generator: {}", seed);
        TFBiomeProvider biomes = this.getBiomeSource().withSeed(seed);
        return new TFChunkGenerator(biomes, this.getDimensionSettings());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final BlockPos func_235956_a_(ServerWorld world, Structure<?> structure, BlockPos pos, int radius, boolean flag) {
        try (Section section = Profiler.STRUCTURE_SEARCHES.punchIn();){
            if (!this.biomeProvider.func_205004_a(structure)) {
                BlockPos blockPos = null;
                return blockPos;
            }
            if (structure == Structure.field_236375_k_) {
                BlockPos blockPos = this.strongholdGenerator.findNearestStronghold(pos);
                return blockPos;
            }
            StructureSeparationSettings settings = this.structureGenerator.getSeparationSettings(structure);
            if (settings == null) {
                BlockPos blockPos = null;
                return blockPos;
            }
            BlockPos blockPos = StructureLocator.find(pos, radius, flag, structure, settings, (IWorld)world, this);
            return blockPos;
        }
        catch (Throwable t) {
            UncheckedException.search(structure.getRegistryName(), t).printStackTrace();
            return null;
        }
    }

    public final boolean func_235952_a_(ChunkPos pos) {
        return this.strongholdGenerator.isStrongholdChunk(pos);
    }

    public final void func_242707_a(DynamicRegistries registries, StructureManager structures, IChunk chunk, TemplateManager templates, long seed) {
        try (Section section = Profiler.STRUCTURE_STARTS.punchIn();){
            this.structureGenerator.generateStructureStarts(chunk, registries, structures, templates);
        }
        catch (Throwable t) {
            CrashHandler.handle(chunk, this, (Throwable)new WorldGenException(Profiler.STRUCTURE_STARTS, t));
        }
    }

    public final void func_235953_a_(ISeedReader world, StructureManager structures, IChunk chunk) {
        try (Section section = Profiler.STRUCTURE_REFS.punchIn();){
            this.structureGenerator.generateStructureReferences(world, chunk, structures);
        }
        catch (Throwable t) {
            CrashHandler.handle(chunk, this, (Throwable)new WorldGenException(Profiler.STRUCTURE_REFS, t));
        }
    }

    public final void func_242706_a(Registry<Biome> registry, IChunk chunk) {
        try (Section section = Profiler.BIOMES.punchIn();){
            this.biomeGenerator.generateBiomes(chunk);
        }
        catch (Throwable t) {
            CrashHandler.handle(chunk, this, (Throwable)new WorldGenException(Profiler.BIOMES, t));
        }
    }

    public final void func_230352_b_(IWorld world, StructureManager structures, IChunk chunk) {
        try (Section section = Profiler.TERRAIN.punchIn();){
            this.terrainGenerator.generateTerrain(world, chunk, structures);
        }
        catch (Throwable t) {
            CrashHandler.handle(chunk, this, (Throwable)new WorldGenException(Profiler.TERRAIN, t));
        }
    }

    public final void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        try (Section section = Profiler.SURFACE.punchIn();){
            this.surfaceGenerator.generateSurface(region, chunk);
        }
        catch (Throwable t) {
            CrashHandler.handle(chunk, this, (Throwable)new WorldGenException(Profiler.SURFACE, t));
        }
    }

    public final void func_230350_a_(long seed, BiomeManager biomes, IChunk chunk, GenerationStage.Carving carver) {
        try (Section section = Profiler.get(carver).punchIn();){
            this.terrainCarver.carveTerrain(biomes, chunk, carver);
        }
        catch (Throwable t) {
            CrashHandler.handle(chunk, this, (Throwable)new WorldGenException(Profiler.AIR_CARVERS, t));
        }
    }

    public final void func_230351_a_(WorldGenRegion region, StructureManager structures) {
        try (Section section = Profiler.DECORATION.punchIn();){
            this.featureGenerator.generateFeatures(region, structures);
        }
        catch (Throwable t) {
            CrashHandler.handle(region, this, (Throwable)new WorldGenException(Profiler.DECORATION, t));
        }
    }

    public final void func_230354_a_(WorldGenRegion region) {
        try (Section section = Profiler.MOB_SPAWNS.punchIn();){
            this.mobGenerator.generateMobs(region);
        }
        catch (Throwable t) {
            CrashHandler.handle(region, this, (Throwable)new WorldGenException(Profiler.MOB_SPAWNS, t));
        }
    }

    public final List<MobSpawnInfo.Spawners> func_230353_a_(Biome biome, StructureManager structures, EntityClassification type, BlockPos pos) {
        return this.mobGenerator.getSpawns(biome, structures, type, pos);
    }

    public final int func_222529_a(int x, int z, Heightmap.Type type) {
        Cell cell = this.localCellResource.get().reset();
        this.biomeProvider.getWorldLookup().applyCell(cell, x, z);
        int level = this.getContext().levels.scale(cell.value) + 1;
        if (type == Heightmap.Type.OCEAN_FLOOR || type == Heightmap.Type.OCEAN_FLOOR_WG) {
            return level;
        }
        return Math.max(this.func_230356_f_(), level);
    }

    public final IBlockReader func_230348_a_(int x, int z) {
        int height = this.func_222529_a(x, z, Heightmap.Type.OCEAN_FLOOR_WG);
        int surface = Math.max(height, this.func_230356_f_() + 1);
        BlockColumn column = ColumnResource.get().column.withCapacity(surface);
        BlockState solid = this.settings.get().func_236115_c_();
        for (int y = 0; y < height; ++y) {
            column.set(y, solid);
        }
        BlockState fluid = this.settings.get().func_236116_d_();
        for (int y = height; y < surface; ++y) {
            column.set(y, fluid);
        }
        return column;
    }

    public final TFBiomeProvider getBiomeSource() {
        return this.biomeProvider;
    }

    public final Generator.Structures getStructureGenerator() {
        return this.structureGenerator;
    }

    public final int func_230355_e_() {
        return this.getContext().levels.worldHeight;
    }

    public final int func_230356_f_() {
        return this.getContext().levels.waterLevel;
    }

    public final int func_205470_d() {
        return this.getContext().levels.groundLevel;
    }

    public final TerraContext getContext() {
        return this.context;
    }

    public final Materials getMaterials() {
        return (Materials)this.context.materials.get();
    }

    public final FeatureManager getFeatureManager() {
        return this.resources.get().featureManager;
    }

    public final GeoManager getGeologyManager() {
        return this.resources.get().geologyManager;
    }

    public final LayerManager getLayerManager() {
        return this.getMaterials().getLayerManager();
    }

    public final SurfaceManager getSurfaceManager() {
        return this.resources.get().surfaceManager;
    }

    public final BlockDataManager getBlockDataManager() {
        return this.resources.get().blockDataManager;
    }

    public final List<ColumnDecorator> getSurfaceDecorators() {
        return this.resources.get().surfaceDecorators;
    }

    public final List<ColumnDecorator> getPostProcessors() {
        return this.resources.get().postProcessors;
    }

    public final void queueChunk(ChunkPos pos) {
        this.queueChunk(pos.field_77276_a, pos.field_77275_b);
    }

    public final void queueChunk(int chunkX, int chunkZ) {
        TileCache tileCache = this.resources.get().tileCache;
        if (tileCache.supportsQueuing()) {
            int rx = tileCache.chunkToRegion(chunkX);
            int rz = tileCache.chunkToRegion(chunkZ);
            tileCache.queueRegion(rx, rz);
        }
    }

    public final Tile getTile(ChunkPos pos) {
        return this.getTile(pos.field_77276_a, pos.field_77275_b);
    }

    public final Tile getTile(int chunkX, int chunkZ) {
        TileCache tileCache = this.resources.get().tileCache;
        int rx = tileCache.chunkToRegion(chunkX);
        int rz = tileCache.chunkToRegion(chunkZ);
        return tileCache.getTile(rx, rz);
    }

    public final ChunkReader getChunkReader(ChunkPos pos) {
        return this.getChunkReader(pos.field_77276_a, pos.field_77275_b);
    }

    public final ChunkReader getChunkReader(int chunkX, int chunkZ) {
        return this.resources.get().tileCache.getChunk(chunkX, chunkZ);
    }

    public static ChunkReader getChunk(IWorld world, ChunkGenerator generator) {
        if (generator instanceof TFChunkGenerator) {
            TFChunkGenerator terra = (TFChunkGenerator)generator;
            if (world instanceof IChunk) {
                IChunk chunk = (IChunk)world;
                return terra.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
            }
            if (world instanceof WorldGenRegion) {
                WorldGenRegion region = (WorldGenRegion)world;
                return terra.getChunkReader(region.func_201679_a(), region.func_201680_b());
            }
        }
        throw new IllegalStateException("Attempted to access TerraForged chunk-generation data from a non-TerraForged chunk generator!");
    }

    private static <TF extends TFChunkGenerator, T> Dynamic<T> encodeGenerator(TF generator, DynamicOps<T> ops) {
        T biomeSource = Codecs.encodeAndGet(TFBiomeProvider.CODEC, generator.getBiomeSource(), ops);
        T dimensionSettings = Codecs.encodeAndGet(DimensionSettings.field_236098_b_, generator.getDimensionSettings(), ops);
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("biome_provider"), biomeSource, (Object)ops.createString("dimension_settings"), dimensionSettings)));
    }

    private static <TF extends TFChunkGenerator, T> TF decodeGenerator(Dynamic<T> dynamic, BiFunction<TFBiomeProvider, Supplier<DimensionSettings>, TF> constructor) {
        TFBiomeProvider biomes = Codecs.decodeAndGet(TFBiomeProvider.CODEC, dynamic.get("biome_provider"));
        Supplier settings = (Supplier)Codecs.decodeAndGet(DimensionSettings.field_236098_b_, dynamic.get("dimension_settings"));
        return (TF)((Object)((TFChunkGenerator)((Object)constructor.apply(biomes, settings))));
    }

    protected static <TF extends TFChunkGenerator> Codec<TF> codec(final BiFunction<TFBiomeProvider, Supplier<DimensionSettings>, TF> constructor) {
        EncoderFunc<TFChunkGenerator> encoder = TFChunkGenerator::encodeGenerator;
        DecoderFunc decoder = new DecoderFunc<TF>(){

            @Override
            public <T> TF _decode(Dynamic<T> dynamic) {
                return (Object)TFChunkGenerator.decodeGenerator(dynamic, constructor);
            }
        };
        return Codecs.create(encoder, decoder);
    }
}

