/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.tile.chunk.ChunkReader;
import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.fix.ChunkCarverFix;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.featuremanager.template.StructureUtils;
import com.terraforged.mod.featuremanager.util.identity.FeatureIdentifier;
import com.terraforged.mod.featuremanager.util.identity.IdentityCache;
import com.terraforged.mod.profiler.watchdog.WarnTimer;
import com.terraforged.mod.profiler.watchdog.Watchdog;
import com.terraforged.mod.profiler.watchdog.WatchdogContext;
import java.util.BitSet;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;

public class TerrainCarver
implements Generator.Carvers {
    private static final String TYPE = "Carver";
    private final TFChunkGenerator generator;
    private final long timeout;
    private final IdentityCache<ConfiguredCarver<?>> identityCache = new IdentityCache<ConfiguredCarver>(FeatureIdentifier::getIdentity);

    public TerrainCarver(TFChunkGenerator generator) {
        this.generator = generator;
        this.timeout = Watchdog.getWatchdogHangTime();
    }

    @Override
    public void carveTerrain(BiomeManager biomes, IChunk chunk, GenerationStage.Carving type) {
        try (WatchdogContext context = Watchdog.punchIn(chunk, this.generator, this.timeout);){
            this.carve(chunk, type, context);
        }
    }

    private void carve(IChunk chunk, GenerationStage.Carving type, WatchdogContext context) {
        boolean nearRiver = this.nearRiver(chunk.func_76632_l());
        boolean nearStructure = StructureUtils.hasOvergroundStructure(chunk);
        ChunkCarverFix carverChunk = new ChunkCarverFix(chunk, this.generator.getMaterials(), nearStructure, nearRiver);
        SharedSeedRandom random = new SharedSeedRandom();
        ChunkPos chunkpos = carverChunk.func_76632_l();
        int chunkX = chunkpos.field_77276_a;
        int chunkZ = chunkpos.field_77275_b;
        int seaLevel = this.generator.func_230356_f_();
        TFBiomeContainer biomeContainer = TFBiomeContainer.getOrNull(chunk);
        BiomeLookup lookup = new BiomeLookup(chunkpos, biomeContainer);
        BitSet mask = carverChunk.getCarvingMask(type);
        Biome biome = TerrainCarver.getBiome(biomeContainer, this.generator.getBiomeSource(), chunkpos);
        BiomeGenerationSettings settings = biome.func_242440_e();
        WarnTimer timer = Watchdog.getWarnTimer();
        ListIterator iterator = settings.func_242489_a(type).listIterator();
        for (int cx = chunkX - 8; cx <= chunkX + 8; ++cx) {
            for (int cz = chunkZ - 8; cz <= chunkZ + 8; ++cz) {
                while (iterator.hasNext()) {
                    int index = iterator.nextIndex();
                    ConfiguredCarver carver = (ConfiguredCarver)((Supplier)iterator.next()).get();
                    random.func_202425_c(this.generator.getSeed() + (long)index, cx, cz);
                    if (!carver.func_222730_a((Random)random, cx, cz)) continue;
                    long timestamp = timer.now();
                    carver.func_227207_a_((IChunk)carverChunk, (Function)lookup, (Random)random, seaLevel, cx, cz, chunkX, chunkZ, mask);
                    Generator.checkTime(TYPE, carver, this.identityCache, timer, timestamp, context);
                }
                while (iterator.hasPrevious()) {
                    iterator.previous();
                }
            }
        }
    }

    private boolean nearRiver(ChunkPos pos) {
        try (ChunkReader reader = this.generator.getChunkReader(pos);){
            boolean bl = reader.getCell((int)8, (int)8).riverMask < 0.33f;
            return bl;
        }
    }

    private static Biome getBiome(@Nullable TFBiomeContainer container, TFBiomeProvider biomeProvider, ChunkPos pos) {
        if (container == null) {
            try (Resource<Cell> resource = Cell.pooled();){
                Biome biome = biomeProvider.lookupBiome(resource.get(), pos.func_180334_c(), pos.func_180333_d(), false);
                return biome;
            }
        }
        return container.getBiome(0, 0);
    }

    private class BiomeLookup
    implements Function<BlockPos, Biome> {
        private final ChunkPos chunkPos;
        private final TFBiomeContainer biomes;
        private final Cell cell = new Cell();

        private BiomeLookup(@Nullable ChunkPos chunkPos, TFBiomeContainer biomes) {
            this.chunkPos = chunkPos;
            this.biomes = biomes;
        }

        @Override
        public Biome apply(BlockPos pos) {
            if (this.biomes != null && pos.func_177958_n() >> 4 == this.chunkPos.field_77276_a && pos.func_177952_p() >> 4 == this.chunkPos.field_77275_b) {
                return this.biomes.getBiome(pos.func_177958_n(), pos.func_177952_p());
            }
            return TerrainCarver.this.generator.getBiomeSource().lookupBiome(this.cell, pos.func_177958_n(), pos.func_177952_p(), false);
        }
    }
}

