/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.terraforged.mod.Log;
import com.terraforged.mod.config.ConfigRef;
import com.terraforged.mod.config.PerfDefaults;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public class ConfigManager {
    private static final String PERF_VERSION = "1.1";
    private static final String GENERAL_VERSION = "1.1";
    private static final Path COMMON_DIR = Paths.get("config", "terraforged").toAbsolutePath();
    public static final ConfigRef BIOME_WEIGHTS = new ConfigRef(() -> ConfigManager.create("biome_weights", cfg -> ConfigManager.set((CommentedConfig)cfg, "#terraforged:example_biome", 10, "Configure biome weights by entering their id and an integer value for their weight (default weight is 10)", "This config will override the weights configured or provided by other mods for TerraForged worlds only.")));
    public static final ConfigRef PERFORMANCE = new ConfigRef("1.1", version -> ConfigManager.create("performance_internal", version, cfg -> {
        ConfigManager.set((CommentedConfig)cfg, "thread_count", PerfDefaults.THREAD_COUNT, "Controls the total number of threads that will be used to generate heightmap tiles.", "Allowing the generator to use more threads can help speed up generation but increases overall", "load on your CPU which may adversely affect performance in other areas of the game engine.");
        ConfigManager.set((CommentedConfig)cfg, "tile_size", 3, "Controls the size of heightmap tiles.", "Smaller tiles are faster to generate but less memory efficient.");
        ConfigManager.set((CommentedConfig)cfg, "batching", true, "Batching breaks heightmap tiles up into smaller pieces that can be generated concurrently.", "This can help improve generation speed by utilizing more threads.", "It is more effective when a higher thread count (+6) is available.");
        ConfigManager.set((CommentedConfig)cfg, "batch_count", 6, "Controls the number of pieces a heightmap tile is divided up into.", "Higher batch counts may be able to utilize more of the available threads, improving performance.");
    }));
    public static final ConfigRef GENERAL = new ConfigRef("1.1", version -> ConfigManager.create("general", version, cfg -> {
        ConfigManager.set((CommentedConfig)cfg, "default_preset", "default", "Set the preset to use when creating a new world.");
        ConfigManager.set((CommentedConfig)cfg, "tooltips", true, "Set whether tooltips should be displayed by default in the config gui.");
        ConfigManager.set((CommentedConfig)cfg, "coords", false, "Set whether coordinates should be displayed by default in the config gui.");
        ConfigManager.set((CommentedConfig)cfg, "async_structure_search", true, "Set whether multiple threads should be used to perform structure searches.", "This can greatly increase the speed of finding structures via the /locate command.");
        ConfigManager.set((CommentedConfig)cfg, "structure_search_timeout", 5000L, "Set the number of milliseconds that a structure search can run for before it is aborted.");
        ConfigManager.set((CommentedConfig)cfg, "feature_warn_time", 100L, "The number of milliseconds a single feature/structure can generate for before a warning", "is printed to the logs. This may help track down mods that are causing world-gen to run slow.", "Set to -1 to disable.");
        ConfigManager.set((CommentedConfig)cfg, "chunkgen_timeout", 60000L, "The number of milliseconds after which the server will be considered 'deadlocked' (when it", "gets stuck trying to generate a feature/structure). This is usually caused by third-party mods.", "Set to -1 to disable deadlock detection & reporting (the game may freeze indefinitely without it).");
        ConfigManager.set((CommentedConfig)cfg, "fixBlockTags", true, "Fixes a vanilla serialization bug for block tags which TerraForged relies on", "to slightly increase the vanilla ore distribution to suit the taller terrain.", "Disable if this causes issues with other mods.");
    }));

    public static void init() {
        Config.setInsertionOrderPreserved((boolean)true);
        BIOME_WEIGHTS.get();
        PERFORMANCE.get();
        GENERAL.get();
        PerfDefaults.getAndPrintPerfSettings();
    }

    private static CommentedFileConfig create(String name, Consumer<CommentedFileConfig> defaulter) {
        return ConfigManager.create(name, "", defaulter);
    }

    private static CommentedFileConfig create(String name, String version, Consumer<CommentedFileConfig> defaulter) {
        Path path = COMMON_DIR.resolve(name + ".conf");
        if (!Files.exists(path, new LinkOption[0])) {
            Log.info("Creating default config: {}", name);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CommentedFileConfig config = CommentedFileConfig.of((Path)path, (ConfigFormat)TomlFormat.instance());
        config.load();
        ConfigManager.update(config, version);
        defaulter.accept(config);
        config.save();
        return config;
    }

    private static void update(CommentedFileConfig config, String version) {
        if (version.isEmpty()) {
            return;
        }
        String currentVersion = (String)config.getOrElse("version", (Object)"unversioned");
        if (currentVersion != null && currentVersion.equals(version)) {
            return;
        }
        Log.info("Updating config: {} -> {}", currentVersion, version);
        config.clear();
        config.setComment("version", " The version of this config. Do not edit (it'll wipe your settings!)");
        config.set("version", (Object)version);
    }

    private static <T> void set(CommentedConfig config, String path, T value, String ... lines) {
        if (path.startsWith("#")) {
            if (config.isEmpty()) {
                path = path.substring(1);
                config.setComment(path, " " + String.join((CharSequence)"\n ", lines));
                config.set(path, value);
            }
        } else if (!config.contains(path)) {
            config.setComment(path, " " + String.join((CharSequence)"\n ", lines));
            config.set(path, value);
        }
    }
}

