/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.terraforged.engine.concurrent.thread.ThreadPools;
import com.terraforged.engine.settings.FilterSettings;
import com.terraforged.mod.Log;
import com.terraforged.mod.config.ConfigManager;

public class PerfDefaults {
    public static final boolean BATCHING = true;
    public static final int TILE_SIZE = 3;
    public static final int BATCH_COUNT = 6;
    public static final int THREAD_COUNT = ThreadPools.defaultPoolSize();
    public static final int MAX_TILE_SIZE = 8;
    public static final int MAX_BATCH_COUNT = 20;
    public static final int MAX_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;

    private static boolean isUsingDefaultPerfSettings(CommentedConfig config) {
        boolean yes = true;
        yes &= ((Boolean)config.getOrElse("batching", (Object)true)).booleanValue();
        yes &= config.getInt("thread_count") == THREAD_COUNT;
        yes &= config.getInt("batch_count") == 6;
        return yes &= config.getInt("tile_size") == 3;
    }

    public static CommentedConfig getAndPrintPerfSettings() {
        CommentedFileConfig config = ConfigManager.PERFORMANCE.get();
        boolean defaults = PerfDefaults.isUsingDefaultPerfSettings((CommentedConfig)config);
        Log.info("Performance Settings [default={}]", defaults);
        Log.info(" - Thread Count: {} (default: {})", config.getInt("thread_count"), THREAD_COUNT);
        Log.info(" - Tile Size: {} (default: {})", config.getInt("tile_size"), 3);
        Log.info(" - Batching: {} (default: {})", config.getOrElse("batching", (Object)true), true);
        Log.info(" - Batch Count: {} (default: {})", config.getInt("batch_count"), 6);
        return config;
    }

    public static int getTileBorderSize(FilterSettings settings) {
        return Math.min(2, Math.max(1, settings.erosion.dropletLifetime / 16));
    }
}

