/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.data.DataGen;
import com.terraforged.mod.featuremanager.FeatureSerializer;
import com.terraforged.mod.featuremanager.util.FeatureDebugger;
import java.io.File;
import java.io.Writer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class WorldGenFeatures
extends DataGen {
    public static void genBiomeFeatures(File dataDir, Biome[] biomes, TFBiomeContext context) {
        if (dataDir.exists() || dataDir.mkdirs()) {
            for (Biome biome : biomes) {
                try {
                    WorldGenFeatures.genBiomeFeatures(dataDir, biome, context);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static void genBiomeFeatures(File dir, Biome biome, TFBiomeContext context) {
        WorldGenFeatures.write(new File(dir, WorldGenFeatures.getJsonPath("features", context.biomes.getRegistryName(biome))), (Writer writer) -> {
            JsonObject root = new JsonObject();
            List stageFeatures = biome.func_242440_e().func_242498_c();
            for (GenerationStage.Decoration type : GenerationStage.Decoration.values()) {
                if (type.ordinal() >= stageFeatures.size()) continue;
                JsonArray features = new JsonArray();
                for (Supplier feature : (List)stageFeatures.get(type.ordinal())) {
                    try {
                        JsonElement element = FeatureSerializer.serialize((ConfiguredFeature)feature.get());
                        features.add(element);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        String name = context.biomes.getName(biome);
                        List<String> errors = FeatureDebugger.getErrors((ConfiguredFeature)feature.get());
                        Log.debug("Unable to serialize feature in biome: {}", name);
                        if (errors.isEmpty()) {
                            Log.debug("Unable to determine issues. See stacktrace:", t);
                            continue;
                        }
                        for (String error : errors) {
                            Log.debug(" - {}", error);
                        }
                    }
                }
                root.add(type.name(), (JsonElement)features);
            }
            WorldGenFeatures.write((JsonElement)root, writer);
        });
    }
}

