/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.featuremanager.template.BlockUtils;
import com.terraforged.mod.featuremanager.util.codec.CodecHelper;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class BushFeature
extends Feature<Config> {
    public static final BushFeature INSTANCE = new BushFeature();
    private static final Vector3i[] logs = new Vector3i[]{new Vector3i(1, 0, 1), new Vector3i(1, 0, -1), new Vector3i(-1, 0, -1), new Vector3i(-1, 0, 1), new Vector3i(2, 0, 1), new Vector3i(2, 0, -1), new Vector3i(-2, 0, 1), new Vector3i(-2, 0, -1), new Vector3i(1, 0, 2), new Vector3i(1, 0, -2), new Vector3i(-1, 0, 2), new Vector3i(-1, 0, -2)};
    private static final Vector3i[] leaves = new Vector3i[]{new Vector3i(0, 0, 1), new Vector3i(0, 0, -1), new Vector3i(1, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 1, 0)};

    public BushFeature() {
        super(Config.CODEC);
        this.setRegistryName("terraforged", "bush");
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, Config config) {
        BlockPos.Mutable log = new BlockPos.Mutable();
        BlockPos.Mutable leaf = new BlockPos.Mutable();
        this.place((IWorld)world, log.func_189533_g((Vector3i)pos), leaf, rand, config);
        for (float chance = rand.nextFloat(); chance < config.size_chance; chance += rand.nextFloat()) {
            BushFeature.addToMutable(log, logs[rand.nextInt(logs.length)]);
            if (!this.place((IWorld)world, log, leaf, rand, config)) break;
        }
        return false;
    }

    private boolean place(IWorld world, BlockPos.Mutable center, BlockPos.Mutable pos, Random random, Config config) {
        center.func_185336_p(world.func_201676_a(Heightmap.Type.WORLD_SURFACE, center.func_177958_n(), center.func_177952_p()));
        if (!BlockUtils.canTreeReplace(world, (BlockPos)center)) {
            return false;
        }
        center.func_189534_c(Direction.DOWN, 1);
        if (!BlockUtils.isSoilOrRock(world, (BlockPos)center)) {
            return false;
        }
        center.func_189534_c(Direction.UP, 1);
        world.func_180501_a((BlockPos)center, config.trunk, 2);
        BlockState leaves = config.leavesWithDistance(1);
        BlockState leavesExtra = config.leavesWithDistance(2);
        for (Vector3i neighbour : BushFeature.leaves) {
            if (neighbour.func_177956_o() == 0 && random.nextFloat() < config.airChance) continue;
            pos.func_189533_g((Vector3i)center);
            BushFeature.addToMutable(pos, neighbour);
            if (!BlockUtils.canTreeReplace(world, (BlockPos)pos)) continue;
            world.func_180501_a((BlockPos)pos, leaves, 2);
            if (neighbour.func_177956_o() == 0 && random.nextFloat() < config.leafChance) {
                pos.func_189534_c(Direction.DOWN, 1);
                if (BlockUtils.canTreeReplace(world, (BlockPos)pos)) {
                    world.func_180501_a((BlockPos)pos, leavesExtra, 2);
                }
                pos.func_189534_c(Direction.UP, 1);
            }
            if (neighbour.func_177956_o() != 0 || !(random.nextFloat() < config.leafChance)) continue;
            pos.func_189534_c(Direction.UP, 1);
            if (!BlockUtils.canTreeReplace(world, (BlockPos)pos)) continue;
            world.func_180501_a((BlockPos)pos, leavesExtra, 2);
        }
        return true;
    }

    private static void addToMutable(BlockPos.Mutable pos, Vector3i add) {
        pos.func_181079_c(pos.func_177958_n() + add.func_177958_n(), pos.func_177956_o() + add.func_177956_o(), pos.func_177952_p() + add.func_177952_p());
    }

    public static <T> Dynamic<T> serialize(Config config, DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("trunk"), CodecHelper.setState(config.trunk, ops), (Object)ops.createString("leaves"), CodecHelper.setState(config.leaves, ops), (Object)ops.createString("air_chance"), (Object)ops.createFloat(config.airChance), (Object)ops.createString("leaf_chance"), (Object)ops.createFloat(config.airChance), (Object)ops.createString("size_chance"), (Object)ops.createFloat(config.size_chance))));
    }

    public static <T> Config deserialize(Dynamic<T> data) {
        BlockState logs = CodecHelper.getState(data.get("trunk"));
        BlockState leaves = CodecHelper.getState(data.get("leaves"));
        float airChance = data.get("air_chance").asFloat(0.075f);
        float leafChance = data.get("leaf_chance").asFloat(0.075f);
        float sizeChance = data.get("size_chance").asFloat(0.75f);
        return new Config(logs, leaves, airChance, leafChance, sizeChance);
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = Codecs.create(BushFeature::serialize, BushFeature::deserialize);
        private final BlockState trunk;
        private final BlockState leaves;
        private final float airChance;
        private final float leafChance;
        private final float size_chance;

        public Config(BlockState trunk, BlockState leaves, float airChance, float leafChance, float size_chance) {
            this.trunk = trunk;
            this.leaves = leaves;
            this.airChance = airChance;
            this.leafChance = leafChance;
            this.size_chance = size_chance;
        }

        public BlockState leavesWithDistance(int distance) {
            if (this.leaves.func_235901_b_((Property)LeavesBlock.field_208494_a)) {
                return (BlockState)this.leaves.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(distance));
            }
            return this.leaves;
        }
    }
}

