/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.feature;

import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;

public class DiskFeature
extends Feature<SphereReplaceConfig> {
    public static final DiskFeature INSTANCE = new DiskFeature();
    private final Module domain = Source.simplex(1, 6, 3);

    private DiskFeature() {
        super(SphereReplaceConfig.field_236516_a_);
        this.setRegistryName("terraforged", "disk");
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, SphereReplaceConfig config) {
        if (!world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return false;
        }
        int cRadius = 6;
        int ySize = 5;
        int i = 0;
        int radius = 4 + rand.nextInt(cRadius);
        float radius2 = (float)(radius * radius) * 0.65f;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                float rad2;
                int dz;
                int dx = x - pos.func_177958_n();
                if (!((float)(dx * dx + (dz = z - pos.func_177952_p()) * dz) <= (rad2 = this.domain.getValue(x, z) * radius2))) continue;
                block2: for (int y = pos.func_177956_o() - ySize; y <= pos.func_177956_o() + ySize && y + 1 < generator.func_230355_e_(); ++y) {
                    blockPos.func_181079_c(x, y, z);
                    BlockState current = world.func_180495_p((BlockPos)blockPos);
                    for (BlockState target : config.field_202434_d) {
                        if (target.func_177230_c() != current.func_177230_c()) continue;
                        world.func_180501_a((BlockPos)blockPos, config.field_214693_a, 2);
                        ++i;
                        continue block2;
                    }
                }
            }
        }
        return i > 0;
    }
}

