/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Matcher {
    private final Set<JsonPrimitive> set;
    private final Map<String, JsonElement> map;

    Matcher(Collection<JsonPrimitive> set, Map<String, JsonElement> map) {
        this.set = set.isEmpty() ? Collections.emptySet() : new HashSet<JsonPrimitive>(set);
        this.map = map.isEmpty() ? Collections.emptyMap() : new HashMap<String, JsonElement>(map);
    }

    public boolean complete() {
        return this.set.isEmpty() && this.map.isEmpty();
    }

    public boolean test(JsonPrimitive value) {
        return this.set.remove(value);
    }

    public boolean test(String key, JsonElement value) {
        JsonElement match = this.map.get(key);
        if (match != null && match.equals(value)) {
            this.map.remove(key);
            return true;
        }
        return false;
    }
}

