/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.matcher.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.terraforged.mod.featuremanager.matcher.feature.Matcher;
import com.terraforged.mod.featuremanager.matcher.feature.Rule;
import java.util.List;

public class Search {
    private final Matcher[] matchers;

    Search(List<Rule> list) {
        this.matchers = (Matcher[])list.stream().map(Rule::createMatcher).toArray(Matcher[]::new);
    }

    public boolean isComplete() {
        for (Matcher matcher : this.matchers) {
            if (!matcher.complete()) continue;
            return true;
        }
        return false;
    }

    public boolean test(JsonPrimitive value) {
        boolean hasMatch = false;
        for (Matcher matcher : this.matchers) {
            hasMatch |= matcher.test(value);
        }
        return hasMatch;
    }

    public boolean test(String key, JsonElement value) {
        boolean hasMatch = false;
        for (Matcher matcher : this.matchers) {
            hasMatch |= matcher.test(key, value);
        }
        return hasMatch;
    }
}

