/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.modifier;

import com.terraforged.mod.featuremanager.matcher.BiomeFeatureMatcher;
import com.terraforged.mod.featuremanager.matcher.biome.BiomeMatcher;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ModifierList<T>
implements Iterable<Modifier<T>> {
    private List<Modifier<T>> list = Collections.emptyList();

    public int size() {
        return this.list.size();
    }

    public void sort() {
        Collections.sort(this.list);
    }

    @Override
    public Iterator<Modifier<T>> iterator() {
        return this.list.iterator();
    }

    public void add(FeatureMatcher featureMatcher, T modifier) {
        this.add(BiomeMatcher.ANY, featureMatcher, modifier);
    }

    public void add(String name, FeatureMatcher featureMatcher, T modifier) {
        this.add(name, BiomeMatcher.ANY, featureMatcher, modifier);
    }

    public void add(BiomeMatcher biomeMatcher, FeatureMatcher featureMatcher, T modifier) {
        this.add("UNNAMED", biomeMatcher, featureMatcher, modifier);
    }

    public void add(String name, BiomeMatcher biomeMatcher, FeatureMatcher featureMatcher, T modifier) {
        BiomeFeatureMatcher matcher = new BiomeFeatureMatcher(name, biomeMatcher, featureMatcher);
        this.add(matcher, modifier);
    }

    public void add(BiomeFeatureMatcher matcher, T modifier) {
        if (this.list.isEmpty()) {
            this.list = new ArrayList<Modifier<T>>();
        }
        this.list.add(new Modifier<T>(matcher, modifier));
    }
}

