/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template.decorator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.mod.featuremanager.template.decorator.Decorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;

public class DecoratorConfig<T extends IWorld> {
    private final Decorator.Factory<T> factory;
    private final List<Decorator<T>> defaultDecorator;
    private final Map<ResourceLocation, List<Decorator<T>>> biomeDecorators;

    private DecoratorConfig(Decorator.Factory<T> factory, List<Decorator<T>> defaultDecorator, Map<ResourceLocation, List<Decorator<T>>> biomeDecorators) {
        this.factory = factory;
        this.defaultDecorator = defaultDecorator;
        this.biomeDecorators = biomeDecorators;
    }

    public T createBuffer(ISeedReader world) {
        return this.factory.wrap(world);
    }

    public List<Decorator<T>> getDecorators(ResourceLocation biome) {
        if (biome == null) {
            return this.defaultDecorator;
        }
        return this.biomeDecorators.getOrDefault(biome, this.defaultDecorator);
    }

    public static <T extends IWorld> DecoratorConfig<T> parse(Decorator.Factory<T> factory, JsonObject config) {
        List<Decorator<T>> defaults = Collections.emptyList();
        Map<ResourceLocation, List<Decorator<T>>> biomes = Collections.emptyMap();
        if (config != null) {
            if (config.has("default")) {
                defaults = DecoratorConfig.parseDecorators(factory, config.getAsJsonObject("default"));
                for (Map.Entry e : config.entrySet()) {
                    if (((String)e.getKey()).equals("default")) continue;
                    ResourceLocation biome = new ResourceLocation((String)e.getKey());
                    List<Decorator<T>> decorators = DecoratorConfig.parseDecorators(factory, ((JsonElement)e.getValue()).getAsJsonObject());
                    if (decorators.isEmpty()) continue;
                    if (biomes.isEmpty()) {
                        biomes = new HashMap<ResourceLocation, List<Decorator<T>>>();
                    }
                    biomes.put(biome, decorators);
                }
            } else {
                defaults = DecoratorConfig.parseDecorators(factory, config);
            }
        }
        return new DecoratorConfig<T>(factory, defaults, biomes);
    }

    private static <T extends IWorld> List<Decorator<T>> parseDecorators(Decorator.Factory<T> factory, JsonObject json) {
        List<Decorator<T>> decorators = Collections.emptyList();
        for (Map.Entry e : json.entrySet()) {
            ResourceLocation name = new ResourceLocation((String)e.getKey());
            Optional<Decorator<T>> decorator = factory.parse(name, (JsonElement)e.getValue());
            if (!decorator.isPresent()) continue;
            if (decorators.isEmpty()) {
                decorators = new ArrayList<Decorator<T>>(json.size());
            }
            decorators.add(decorator.get());
        }
        return decorators;
    }
}

