/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.transformer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.terraforged.engine.world.biome.map.BiomeContext;
import com.terraforged.mod.featuremanager.matcher.feature.FeatureMatcher;
import com.terraforged.mod.featuremanager.modifier.Jsonifiable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class FeatureTransformer
implements Function<JsonElement, JsonElement>,
Jsonifiable {
    public static final FeatureTransformer NONE = FeatureTransformer.builder().build();
    private static final ThreadLocal<Context> LOCAL_CONTEXT = ThreadLocal.withInitial(() -> new Context());
    private final boolean hasTransformations;
    private final Map<String, JsonElement> keyTransformers;
    private final Map<JsonPrimitive, JsonPrimitive> valueTransformers;

    private FeatureTransformer(Builder builder) {
        this.keyTransformers = builder.keyTransformers;
        this.valueTransformers = builder.valueTransformers;
        this.hasTransformations = !this.keyTransformers.isEmpty() || !this.valueTransformers.isEmpty();
        builder.keyTransformers = Collections.emptyMap();
        builder.valueTransformers = Collections.emptyMap();
    }

    @Override
    public String getType() {
        return "transform";
    }

    @Override
    public JsonElement toJson(BiomeContext<?> context) {
        JsonObject root = new JsonObject();
        for (Map.Entry<JsonPrimitive, JsonPrimitive> entry : this.valueTransformers.entrySet()) {
            root.add(entry.getKey().getAsString(), (JsonElement)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.keyTransformers.entrySet()) {
            root.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return root;
    }

    @Override
    public JsonElement apply(JsonElement element) {
        Context context = FeatureTransformer.LOCAL_CONTEXT.get().init(this.keyTransformers.size() + this.valueTransformers.size());
        JsonElement json = this.transform(element, context);
        if (context.isComplete()) {
            return json;
        }
        return element;
    }

    private JsonElement transform(JsonElement element, Context context) {
        if (this.hasTransformations) {
            if (element.isJsonArray()) {
                return this.transformArray(element.getAsJsonArray(), context);
            }
            if (element.isJsonObject()) {
                return this.transformObject(element.getAsJsonObject(), context);
            }
            if (element.isJsonPrimitive()) {
                return this.transformValue(element.getAsJsonPrimitive(), context);
            }
        }
        return element;
    }

    private JsonPrimitive transformValue(JsonPrimitive primitive, Context context) {
        JsonPrimitive result = this.valueTransformers.get(primitive);
        if (result != null) {
            context.add(primitive);
            return result;
        }
        return primitive;
    }

    private JsonArray transformArray(JsonArray source, Context context) {
        JsonArray dest = new JsonArray();
        for (JsonElement element : source) {
            dest.add(this.transform(element, context));
        }
        return dest;
    }

    private JsonObject transformObject(JsonObject source, Context context) {
        JsonObject dest = new JsonObject();
        for (Map.Entry entry : source.entrySet()) {
            JsonElement result = this.transformEntry((String)entry.getKey(), (JsonElement)entry.getValue(), context);
            dest.add((String)entry.getKey(), result);
        }
        return dest;
    }

    private JsonElement transformEntry(String key, JsonElement value, Context context) {
        JsonElement keyResult = this.keyTransformers.get(key);
        if (keyResult != null) {
            context.add(key);
            return keyResult;
        }
        return this.transform(value, context);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static FeatureTransformer key(String key, Object value) {
        return FeatureTransformer.builder().key(key, FeatureMatcher.arg(value)).build();
    }

    public static <T> FeatureTransformer replace(T find, T replace) {
        JsonElement f = FeatureMatcher.arg(find);
        JsonElement r = FeatureMatcher.arg(replace);
        if (f.isJsonPrimitive() && r.isJsonPrimitive()) {
            return FeatureTransformer.builder().value(f.getAsJsonPrimitive(), r.getAsJsonPrimitive()).build();
        }
        return NONE;
    }

    public static class Builder {
        private Map<String, JsonElement> keyTransformers = Collections.emptyMap();
        private Map<JsonPrimitive, JsonPrimitive> valueTransformers = Collections.emptyMap();

        public Builder key(String key, boolean value) {
            return this.key(key, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
        }

        public Builder key(String key, Number value) {
            return this.key(key, (JsonElement)new JsonPrimitive(value));
        }

        public Builder key(String key, String value) {
            return this.key(key, (JsonElement)new JsonPrimitive(value));
        }

        public Builder key(String key, JsonElement value) {
            if (this.keyTransformers.isEmpty()) {
                this.keyTransformers = new HashMap<String, JsonElement>();
            }
            this.keyTransformers.put(key, value);
            return this;
        }

        public Builder value(boolean find, boolean replace) {
            return this.value(new JsonPrimitive(Boolean.valueOf(find)), new JsonPrimitive(Boolean.valueOf(replace)));
        }

        public Builder value(Number find, Number replace) {
            return this.value(new JsonPrimitive(find), new JsonPrimitive(replace));
        }

        public Builder value(String find, String replace) {
            return this.value(new JsonPrimitive(find), new JsonPrimitive(replace));
        }

        public Builder value(JsonPrimitive find, JsonPrimitive replace) {
            if (this.valueTransformers.isEmpty()) {
                this.valueTransformers = new HashMap<JsonPrimitive, JsonPrimitive>();
            }
            this.valueTransformers.put(find, replace);
            return this;
        }

        public FeatureTransformer build() {
            return new FeatureTransformer(this);
        }
    }

    private static class Context {
        private int size;
        private final Set<Object> visited = new HashSet<Object>();

        private Context() {
        }

        private Context init(int size) {
            this.size = size;
            this.visited.clear();
            return this;
        }

        private void add(Object o) {
            this.visited.add(o);
        }

        private boolean isComplete() {
            return this.visited.size() == this.size;
        }
    }
}

