/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material;

import com.terraforged.engine.concurrent.Resource;
import com.terraforged.mod.Log;
import com.terraforged.mod.api.material.WGTags;
import com.terraforged.mod.api.material.layer.LayerManager;
import com.terraforged.mod.api.material.state.States;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.chunk.util.DummyBlockReader;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Materials {
    private static final Comparator<IForgeRegistryEntry<?>> COMPARATOR = Comparator.comparing(IForgeRegistryEntry::getRegistryName);
    public final LayerManager layerManager = new LayerManager();
    public final Set<Block> stone;
    public final Set<Block> dirt = Materials.createSet(WGTags.DIRT, States.DIRT.getBlock());
    public final Set<Block> clay = Materials.createSet(WGTags.CLAY, States.CLAY.getBlock());
    public final Set<Block> sediment = Materials.createSet(WGTags.SEDIMENT, States.GRAVEL.getBlock());
    public final Set<Block> erodible = Materials.createSet(WGTags.ERODIBLE, null);

    private Materials(TerraSettings settings) {
        this.stone = settings.miscellaneous.oreCompatibleStoneOnly ? Materials.createSet(WGTags.STONE, States.STONE.getBlock(), (ITag.INamedTag<Block>)BlockTags.field_242172_aH) : Materials.createSet(WGTags.STONE, States.STONE.getBlock());
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public boolean isStone(Block block) {
        return this.stone.contains(block);
    }

    public boolean isEarth(Block block) {
        return this.dirt.contains(block);
    }

    public boolean isClay(Block block) {
        return this.clay.contains(block);
    }

    public boolean isSediment(Block block) {
        return this.sediment.contains(block);
    }

    public boolean isErodible(Block block) {
        return this.erodible.contains(block);
    }

    public boolean isAir(Block block) {
        return block instanceof AirBlock;
    }

    public boolean isGrass(Block block) {
        return block instanceof GrassBlock || block instanceof MyceliumBlock;
    }

    private static Set<Block> createSet(ITag<Block> tag, Block def) {
        try {
            ObjectOpenHashSet set = new ObjectOpenHashSet((Collection)tag.func_230236_b_());
            if (set.isEmpty() && def != null) {
                set.add((Object)def);
            }
            return ObjectSets.unmodifiable((ObjectSet)set);
        }
        catch (Throwable t) {
            return Collections.singleton(def);
        }
    }

    private static Set<Block> createSet(ITag.INamedTag<Block> tag, Block def, ITag.INamedTag<Block> required) {
        try {
            ObjectOpenHashSet set = new ObjectOpenHashSet((Collection)tag.func_230236_b_());
            set.removeIf(block -> Materials.isAbsent(block, tag, required));
            if (set.isEmpty() && def != null) {
                set.add((Object)def);
            }
            return ObjectSets.unmodifiable((ObjectSet)set);
        }
        catch (Throwable t) {
            return Collections.singleton(def);
        }
    }

    private static boolean isAbsent(Block block, ITag.INamedTag<Block> a, ITag.INamedTag<Block> b) {
        if (!b.func_230235_a_((Object)block)) {
            Log.info("Block {} is in tag {} but not tag {}. It has been excluded from TerraForged's rock layer generation!", block.getRegistryName(), a.func_230234_a_(), b.func_230234_a_());
            return true;
        }
        return false;
    }

    public static float getHardness(BlockState state) {
        try (Resource<DummyBlockReader> reader = DummyBlockReader.pooled();){
            reader.get().set(state);
            float f = state.func_185887_b((IBlockReader)reader.get(), BlockPos.field_177992_a);
            return f;
        }
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> toList(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(COMPARATOR);
        return Collections.unmodifiableList(list);
    }

    public static Materials create(TerraSettings settings) {
        return new Materials(settings);
    }
}

