/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material.geology;

import com.terraforged.engine.Seed;
import com.terraforged.engine.world.geology.Geology;
import com.terraforged.engine.world.geology.Strata;
import com.terraforged.mod.api.material.geology.GeologyManager;
import com.terraforged.mod.api.material.geology.StrataConfig;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoGenerator;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;

public class GeoManager
implements GeologyManager {
    private static final int SEED_OFFSET = -34678;
    private final Module selector;
    private final Materials materials;
    private final TFBiomeContext context;
    private final GeoGenerator builder;
    private final Geology<BlockState> general;
    private final Map<Biome, Geology<BlockState>> specific = new HashMap<Biome, Geology<BlockState>>();

    public GeoManager(TerraContext context) {
        Seed seed = context.seed.offset(-34678);
        int scale = context.terraSettings.miscellaneous.strataRegionSize;
        this.selector = Source.cell(seed.next(), scale).warp(seed.next(), scale / 4, 2, (double)scale / 2.0).warp(seed.next(), 15, 2, 30.0);
        this.materials = (Materials)context.materials.get();
        this.general = new Geology(this.selector);
        this.builder = new GeoGenerator(this.materials);
        this.context = context.biomeContext;
        this.init(seed);
    }

    @Override
    public GeoGenerator getStrataGenerator() {
        return this.builder;
    }

    @Override
    public void register(Strata<BlockState> strata) {
        this.general.add(strata);
    }

    @Override
    public void register(RegistryKey<Biome> biome, Strata<BlockState> strata) {
        this.register(biome, strata, false);
    }

    @Override
    public void register(RegistryKey<Biome> biome, Strata<BlockState> strata, boolean inheritGlobal) {
        Geology<Object> geology = this.specific.get(biome);
        if (geology == null) {
            geology = new Geology(this.selector);
            this.specific.put(this.context.biomes.get(biome), geology);
            if (inheritGlobal) {
                geology.add(this.general);
            }
        }
        geology.add(strata);
    }

    @Override
    public void register(RegistryKey<Biome> biome, Geology<BlockState> geology) {
        this.specific.put(this.context.biomes.get(biome), geology);
    }

    public Geology<BlockState> getGeology(Biome biome) {
        return this.specific.getOrDefault(biome, this.general);
    }

    public Strata<BlockState> getStrata(Biome biome, float value) {
        return this.getGeology(biome).getStrata(value);
    }

    private void init(Seed seed) {
        StrataConfig config = new StrataConfig();
        GeoGenerator generator = new GeoGenerator(this.materials);
        for (int i = 0; i < 100; ++i) {
            Strata<BlockState> strata = generator.generate(seed.next(), 128, config);
            this.general.add(strata);
        }
    }
}

