/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.profiler.crash;

import com.google.gson.JsonElement;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.config.ConfigManager;
import com.terraforged.mod.config.ConfigRef;
import com.terraforged.mod.profiler.ProfilerPrinter;
import com.terraforged.mod.util.DataUtils;
import com.terraforged.mod.util.reflect.Accessor;
import com.terraforged.mod.util.reflect.FieldAccessor;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrashReportBuilder {
    private static final FieldAccessor<CrashReport, ?> ACCESSOR = Accessor.field(CrashReport.class, Boolean.TYPE);

    public static CrashReport buildCrashReport(IChunk chunk, TFChunkGenerator generator, Throwable t) {
        CrashReport report = new CrashReport(t.getMessage(), t.getCause());
        ACCESSOR.setUnchecked(report, false);
        try {
            CrashReportBuilder.addContext(chunk, generator, report);
        }
        catch (Throwable ctx) {
            report.func_85058_a("Reporting Exception").func_71507_a("Uh Oh", (Object)ctx);
        }
        return report;
    }

    private static void addContext(IChunk chunk, TFChunkGenerator generator, CrashReport report) {
        CrashReportBuilder.addContext(chunk, report.func_85058_a("Current Chunk"));
        CrashReportBuilder.addContext(generator, report.func_85058_a("TerraForged ChunkGenerator"));
        CrashReportBuilder.addContext(generator.getBiomeSource(), report.func_85058_a("TerraForged BiomeProvider"));
        CrashReportBuilder.addContext(ConfigManager.PERFORMANCE, report.func_85058_a("TerraForged Performance Config"));
        CrashReportBuilder.addContext(ConfigManager.BIOME_WEIGHTS, report.func_85058_a("TerraForged Biome Weights Config"));
        CrashReportBuilder.addProfilerContext(report.func_85058_a("TerraForged Profiler"));
    }

    private static void addContext(IChunk chunk, CrashReportCategory report) {
        report.func_71507_a("Pos", (Object)chunk.func_76632_l());
        report.func_71507_a("Status", (Object)chunk.func_201589_g().func_222596_d());
        report.func_71507_a("Structure Starts", CrashReportBuilder.getStructures(chunk.func_201609_c()));
        report.func_71507_a("Structure Refs", CrashReportBuilder.getStructures(chunk.func_201604_d()));
    }

    private static void addContext(TFChunkGenerator generator, CrashReportCategory report) {
        report.func_71507_a("Seed", (Object)generator.getSeed());
        report.func_71507_a("Settings", (Object)DataUtils.toJson(generator.getContext().terraSettings));
    }

    private static void addContext(TFBiomeProvider biomes, CrashReportCategory report) {
        report.func_71507_a("Overworld Biomes", biomes.func_235203_c_().stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList()));
    }

    private static void addContext(ConfigRef ref, CrashReportCategory report) {
        ref.forEach((arg_0, arg_1) -> ((CrashReportCategory)report).func_71507_a(arg_0, arg_1));
    }

    private static void addProfilerContext(CrashReportCategory report) {
        StringWriter writer = new StringWriter();
        try {
            ProfilerPrinter.print(writer, "\t\t");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        report.func_71507_a("Timings", (Object)("\n" + writer.toString()));
    }

    private static List<String> getStructures(Map<Structure<?>, ?> map) {
        return map.keySet().stream().map(CrashReportBuilder::getStructureName).sorted().collect(Collectors.toList());
    }

    private static String getStructureName(Structure<?> structure) {
        ResourceLocation name = structure.getRegistryName();
        if (name == null) {
            return structure.func_143025_a();
        }
        return name.toString();
    }

    private static String print(JsonElement jsonElement) {
        return "\n" + jsonElement.toString();
    }
}

