/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.world.WorldGenerator;
import com.terraforged.engine.world.WorldGeneratorFactory;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.settings.preset.Preset;
import com.terraforged.mod.chunk.settings.preset.PresetManager;
import com.terraforged.mod.data.DataGen;
import com.terraforged.mod.profiler.Profiler;
import com.terraforged.mod.server.command.arg.TerrainArgType;
import com.terraforged.mod.server.command.search.BiomeSearchTask;
import com.terraforged.mod.server.command.search.BothSearchTask;
import com.terraforged.mod.server.command.search.TerrainSearchTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TerraCommand {
    private static final TextFormatting TITLE_FORMAT = TextFormatting.ITALIC;
    private static final TextFormatting SECONDARY_FORMAT = TextFormatting.YELLOW;
    private static final TextFormatting PREFIX_FORMAT = TextFormatting.GOLD;
    private static final Map<UUID, Integer> SEARCH_IDS = Collections.synchronizedMap(new HashMap());
    private static final BiFunction<UUID, Integer, Integer> INCREMENTER = (k, v) -> v == null ? 0 : v + 1;

    public static void init() {
        ArgumentTypes.func_218136_a((String)"terraforged:terrain", TerrainArgType.class, (IArgumentSerializer)new ArgumentSerializer(TerrainArgType::new));
    }

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        Log.info("Registering /terra command", new Object[0]);
        TerraCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(TerraCommand.command());
    }

    private static LiteralArgumentBuilder<CommandSource> command() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").requires(source -> source.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"benchmark").then(Commands.func_197057_a((String)"reset").executes(TerraCommand::benchmarkStart))).then(Commands.func_197057_a((String)"stats").executes(TerraCommand::benchmarkStats)))).then(Commands.func_197057_a((String)"query").executes(TerraCommand::query))).then(Commands.func_197057_a((String)"data").then(Commands.func_197057_a((String)"dump").executes(TerraCommand::dump)))).then(Commands.func_197057_a((String)"preset").then(Commands.func_197057_a((String)"save").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(TerraCommand::savePreset))))).then(Commands.func_197057_a((String)"debug").executes(TerraCommand::debugBiome))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").then(Commands.func_197057_a((String)"biome").then(Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SuggestionProviders.field_239574_d_).executes(TerraCommand::findBiome)))).then(Commands.func_197057_a((String)"terrain").then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).executes(TerraCommand::findTerrain)))).then(Commands.func_197057_a((String)"both").then(Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SuggestionProviders.field_239574_d_).then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).executes(TerraCommand::findTerrainAndBiome)))));
    }

    private static int query(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraCommand.getContext(context);
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_();
        TFBiomeProvider biomeProvider = TerraCommand.getBiomeProvider(context);
        try (Resource<Cell> cell = Cell.pooled();){
            Biome biome = biomeProvider.lookupBiome(cell.get(), pos.func_177958_n(), pos.func_177952_p(), false);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("At ").func_230529_a_((ITextComponent)TerraCommand.createTeleportMessage(pos)).func_230529_a_((ITextComponent)new StringTextComponent(": TerrainType = ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(cell.get().terrain.getName())).func_230529_a_((ITextComponent)new StringTextComponent(", Biome = ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(biome.getRegistryName())).func_230529_a_((ITextComponent)new StringTextComponent(", BiomeType = ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(cell.get().biome.name())), false);
        }
        return 1;
    }

    private static int benchmarkStart(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Profiler.reset();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TerraCommand.createText("Reset profiler", new TextFormatting[0]), false);
        return 1;
    }

    private static int benchmarkStats(CommandContext<CommandSource> context) throws CommandSyntaxException {
        long fastest = 0L;
        long slowest = 0L;
        double average = 0.0;
        for (Profiler profiler : Profiler.values()) {
            average += profiler.averageMS();
            slowest += profiler.maxMS();
            fastest += profiler.minMS();
            ((CommandSource)context.getSource()).func_197030_a(profiler.toText(), false);
        }
        long min = fastest;
        long max = slowest;
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TerraCommand.createText("Chunk Average", PREFIX_FORMAT).func_240702_b_(String.format(": %.3fms", average)).func_240700_a_(style -> style.func_240716_a_(Profiler.createHoverStats(min, max))), false);
        return 1;
    }

    private static int dump(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context);
        try {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Exporting data"), true);
            DataGen.dumpData(terraContext.biomeContext);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return 1;
    }

    private static int savePreset(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context);
        String name = StringArgumentType.getString(context, (String)"name");
        Preset preset = new Preset(name, terraContext.terraSettings);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Saving preset: " + preset.getName()), true);
        PresetManager presets = PresetManager.load();
        presets.add(preset);
        presets.saveAll();
        return 1;
    }

    private static int debugBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        BlockPos position = player.func_233580_cy_();
        int x = position.func_177958_n();
        int z = position.func_177952_p();
        long seed = player.func_71121_q().func_72905_C();
        BiomeProvider biomeProvider = player.func_71121_q().func_72863_F().field_186029_c.func_202090_b();
        Biome actual = player.func_71121_q().func_226691_t_(position);
        Biome biome = ColumnFuzzedBiomeMagnifier.INSTANCE.func_225532_a_(seed, x, 0, z, (BiomeManager.IBiomeReader)biomeProvider);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("At ").func_230529_a_((ITextComponent)TerraCommand.createTeleportMessage(position)).func_230529_a_((ITextComponent)new StringTextComponent(": Actual Biome = ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(actual.getRegistryName())).func_230529_a_((ITextComponent)new StringTextComponent(", Lookup Biome = ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(biome.getRegistryName())), false);
        return 1;
    }

    private static int findTerrain(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context);
        Terrain type = TerrainArgType.getTerrain(context, "terrain");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        WorldGenerator generator = ((WorldGeneratorFactory)terraContext.worldGenerator.get()).get();
        TerrainSearchTask search = new TerrainSearchTask(pos, type, TerraCommand.getChunkGenerator(context), generator);
        int identifier = TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TerraCommand.createPrefix(identifier).func_230529_a_((ITextComponent)new StringTextComponent(" Searching for ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(type.getName())).func_230529_a_((ITextComponent)new StringTextComponent("...")), false);
        return 1;
    }

    private static int findBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraCommand.getContext(context);
        Biome biome = TerraCommand.getBiome(context, "biome");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        ServerWorld world = ((CommandSource)context.getSource()).func_197035_h().func_71121_q();
        BiomeSearchTask search = new BiomeSearchTask(pos, biome, world.func_72863_F().func_201711_g(), TerraCommand.getBiomeProvider(context));
        int identifier = TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TerraCommand.createPrefix(identifier).func_230529_a_((ITextComponent)new StringTextComponent(" Searching for ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(biome.getRegistryName())).func_230529_a_((ITextComponent)new StringTextComponent("...")), false);
        return 1;
    }

    private static int findTerrainAndBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context);
        Terrain target = TerrainArgType.getTerrain(context, "terrain");
        Biome biome = TerraCommand.getBiome(context, "biome");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_233580_cy_();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        WorldGenerator generator = ((WorldGeneratorFactory)terraContext.worldGenerator.get()).get();
        BiomeSearchTask biomeSearch = new BiomeSearchTask(pos, biome, TerraCommand.getChunkGenerator(context), TerraCommand.getBiomeProvider(context));
        TerrainSearchTask terrainSearch = new TerrainSearchTask(pos, target, TerraCommand.getChunkGenerator(context), generator);
        BothSearchTask search = new BothSearchTask(pos, biomeSearch, terrainSearch);
        int identifier = TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TerraCommand.createPrefix(identifier).func_230529_a_((ITextComponent)new StringTextComponent(" Searching for ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(biome.getRegistryName())).func_230529_a_((ITextComponent)new StringTextComponent(" and ")).func_230529_a_((ITextComponent)TerraCommand.createPrimary(target.getName())).func_230529_a_((ITextComponent)new StringTextComponent("...")), false);
        return 1;
    }

    private static int doSearch(MinecraftServer server, UUID userId, Supplier<BlockPos> supplier) {
        int identifier = SEARCH_IDS.compute(userId, INCREMENTER);
        CompletableFuture.supplyAsync(supplier).thenAccept(pos -> server.func_222817_e(() -> {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(userId);
            if (player == null) {
                SEARCH_IDS.remove(userId);
                return;
            }
            if (pos == BlockPos.field_177992_a) {
                IFormattableTextComponent message = TerraCommand.createPrefix(identifier).func_230529_a_((ITextComponent)new StringTextComponent(" Location not found :["));
                player.func_145747_a((ITextComponent)message, Util.field_240973_b_);
                return;
            }
            double distance = Math.sqrt(player.func_233580_cy_().func_177951_i((Vector3i)pos));
            IFormattableTextComponent result = TerraCommand.createPrefix(identifier).func_230529_a_((ITextComponent)new StringTextComponent(" Nearest match: ")).func_230529_a_((ITextComponent)TerraCommand.createTeleportMessage(pos)).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" Distance: %.2f", distance)));
            player.func_145747_a((ITextComponent)result, Util.field_240973_b_);
        }));
        return identifier;
    }

    private static TerraContext getContext(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return TerraCommand.getTFChunkGenerator(context).getContext();
    }

    private static Biome getBiome(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocationArgument.func_197195_e(context, (String)name);
        return (Biome)((CommandSource)context.getSource()).func_197028_i().func_244267_aX().func_230521_a_(Registry.field_239720_u_).flatMap(registry -> registry.func_241873_b(location)).orElseThrow(() -> TerraCommand.createException("biome", "Unrecognized biome %s", location));
    }

    private static String getBiomeName(CommandContext<CommandSource> context, Biome biome) {
        return ((CommandSource)context.getSource()).func_197028_i().func_244267_aX().func_230521_a_(Registry.field_239720_u_).map(r -> r.func_177774_c((Object)biome)).map(Objects::toString).orElse("unknown");
    }

    private static TFChunkGenerator getTFChunkGenerator(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ChunkGenerator generator = ((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_201711_g();
        if (generator instanceof TFChunkGenerator) {
            return (TFChunkGenerator)generator;
        }
        throw TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]);
    }

    private static ChunkGenerator getChunkGenerator(CommandContext<CommandSource> context) {
        return ((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_201711_g();
    }

    private static TFBiomeProvider getBiomeProvider(CommandContext<CommandSource> context) {
        return (TFBiomeProvider)((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_201711_g().func_202090_b();
    }

    private static CommandSyntaxException createException(String type, String message, Object ... args) {
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent(type)), (Message)new StringTextComponent(String.format(message, args)));
    }

    private static IFormattableTextComponent createTeleportMessage(BlockPos pos) {
        return TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})).func_240700_a_(s -> s.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip"))));
    }

    private static IFormattableTextComponent createPrefix(int identifier) {
        return new StringTextComponent("").func_230529_a_((ITextComponent)TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent(String.format("%03d", identifier))).func_240700_a_(style -> style.func_240712_a_(PREFIX_FORMAT)));
    }

    private static IFormattableTextComponent createPrimary(@Nullable Object name) {
        return TerraCommand.createText(name, TITLE_FORMAT);
    }

    private static IFormattableTextComponent createText(@Nullable Object name, TextFormatting ... formatting) {
        String title = name == null ? "null" : name.toString();
        return new StringTextComponent("").func_230529_a_((ITextComponent)new StringTextComponent(title).func_240700_a_(style -> {
            style.func_240720_a_(formatting);
            return style;
        }));
    }
}

