/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command.search;

import com.terraforged.engine.concurrent.cache.SafeCloseable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public abstract class Search
implements Supplier<BlockPos>,
SafeCloseable {
    protected static final int MIN_RADIUS = 128;
    protected static final int MAX_RADIUS = 24000;
    private final BlockPos center;
    private final int minRadius;
    private final int maxRadius;
    private final double minRadius2;

    public Search(BlockPos center) {
        this(center, 128);
    }

    public Search(BlockPos center, int minRadius) {
        this(center, minRadius, 24000);
    }

    public Search(BlockPos center, int minRadius, int maxRadius) {
        this.center = center;
        this.minRadius = minRadius;
        this.minRadius2 = minRadius * minRadius;
        this.maxRadius = Math.min(maxRadius, 24000);
    }

    public int getMinRadius() {
        return this.minRadius;
    }

    public int getSpacing() {
        return 16;
    }

    @Override
    public void close() {
    }

    @Override
    public BlockPos get() {
        int radius = this.maxRadius;
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        int size = radius + 1 + radius;
        long max = (long)size * (long)size;
        long timeOut = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (long i = 0L; i < max && System.currentTimeMillis() <= timeOut; ++i) {
            if (-radius <= x && x <= radius && -radius <= z && z <= radius) {
                pos.func_181079_c(this.center.func_177958_n() + x * this.getSpacing(), this.center.func_177956_o(), this.center.func_177952_p() + z * this.getSpacing());
                if ((this.minRadius2 == 0.0 || this.center.func_177951_i((Vector3i)pos) >= this.minRadius2) && this.test((BlockPos)pos)) {
                    return this.success(pos);
                }
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                size = dx;
                dx = -dz;
                dz = size;
            }
            x += dx;
            z += dz;
        }
        return this.fail(BlockPos.field_177992_a);
    }

    public abstract boolean test(BlockPos var1);

    public BlockPos success(BlockPos.Mutable pos) {
        return pos.func_185334_h();
    }

    public BlockPos fail(BlockPos pos) {
        return pos;
    }
}

