/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.terraforged.engine.Engine;
import com.terraforged.mod.Log;

public class Environment {
    private static final int MIN_CORES = 4;
    private static final boolean dev = System.getProperty("dev") != null;
    private static final boolean verbose = System.getProperty("verbose") != null;
    private static final boolean vanillaBiomes = System.getProperty("vanillaBiomes") != null;

    public static boolean isDev() {
        return dev;
    }

    public static boolean isVerbose() {
        return dev || verbose;
    }

    public static boolean isVanillaBiomes() {
        return vanillaBiomes;
    }

    public static void log() {
        Log.info("Environment: dev={}, stable={}, vanilla={}", dev, Engine.ENFORCE_STABLE_OPTIONS, vanillaBiomes);
        Environment.perf();
    }

    private static void perf() {
        int processors = Runtime.getRuntime().availableProcessors();
        if (processors < 4) {
            Log.warn("Running on unsupported cpu! TerraForged may not work correctly! Available Processors: {}", processors);
            return;
        }
        if (processors == 4) {
            Log.info("Running on minimum supported core-count. Performance may not be optimal!", new Object[0]);
        }
    }
}

