/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.terraforged.mod.Log;
import com.terraforged.mod.config.ConfigManager;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TagFixer<T>
implements ITag.INamedTag<T> {
    public static final String FIX_BLOCK_TAG_KEY = "fixBlockTags";
    public static final boolean FIX_BLOCK_TAG_DEFAULT = true;
    private static volatile boolean postInit = false;
    private final ResourceLocation name;
    private final ITag<T> delegate;

    public TagFixer(ResourceLocation name, ITag<T> delegate) {
        this.name = name;
        this.delegate = delegate;
    }

    public ResourceLocation func_230234_a_() {
        return this.name;
    }

    public boolean func_230235_a_(T t) {
        return this.delegate.func_230235_a_(t);
    }

    public List<T> func_230236_b_() {
        return this.delegate.func_230236_b_();
    }

    public String toString() {
        return "TagFixer{name=" + this.name + ", delegate=" + this.delegate + '}';
    }

    public static ITag<Block> wrap(ITag<Block> tag) {
        if (!postInit) {
            return tag;
        }
        if (tag instanceof ITag.INamedTag) {
            return tag;
        }
        if (!ConfigManager.GENERAL.getBool(FIX_BLOCK_TAG_KEY, true)) {
            return tag;
        }
        ResourceLocation name = TagCollectionManager.func_242178_a().func_241835_a().func_232973_a_(tag);
        if (name != null) {
            return new TagFixer<Block>(name, tag);
        }
        Log.warn("Failed to find name for tag: {}", tag.func_230236_b_().stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList()));
        return tag;
    }

    public static void markPostInit() {
        postInit = true;
    }
}

