/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.reflect;

import com.terraforged.mod.util.reflect.FieldAccessor;
import com.terraforged.mod.util.reflect.MethodAccessor;
import com.terraforged.mod.util.reflect.ReflectUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public class Accessor<A> {
    protected final A access;

    public Accessor(A access) {
        this.access = access;
    }

    public static <O, T> FieldAccessor<O, T> field(Class<O> owner, Class<T> fieldType) {
        return Accessor.field(owner, fieldType, f -> true);
    }

    public static <O, T> FieldAccessor<O, T> field(Class<O> owner, Class<T> fieldType, Predicate<Field> predicate) {
        Field field = (Field)ReflectUtils.accessMember(owner, fieldType, (AccessibleObject[])owner.getDeclaredFields(), Field::getType, predicate);
        return new FieldAccessor(fieldType, field);
    }

    public static <O> MethodAccessor<O> method(Class<O> owner, Predicate<Method> predicate) {
        Method method = (Method)ReflectUtils.accessMember(owner, Void.class, (AccessibleObject[])owner.getDeclaredMethods(), Method::getReturnType, predicate);
        return new MethodAccessor(method);
    }

    public static <O, T> MethodAccessor<O> method(Class<O> owner, Class<T> type, Predicate<Method> predicate) {
        Method method = (Method)ReflectUtils.accessMember(owner, type, (AccessibleObject[])owner.getDeclaredMethods(), Method::getReturnType, predicate);
        return new MethodAccessor(method);
    }
}

