/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.setup;

import com.terraforged.engine.world.GeneratorContext;
import com.terraforged.engine.world.biome.modifier.ModifierManager;
import com.terraforged.engine.world.terrain.provider.TerrainProvider;
import com.terraforged.mod.api.biome.surface.SurfaceManager;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.api.chunk.column.DecoratorManager;
import com.terraforged.mod.api.event.SetupEvent;
import com.terraforged.mod.api.material.geology.GeologyManager;
import com.terraforged.mod.api.material.layer.LayerManager;
import com.terraforged.mod.featuremanager.modifier.FeatureModifiers;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SetupHooks {
    public static <T extends TerrainProvider> T setup(T provider, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Terrain(provider, context));
        return provider;
    }

    public static <T extends SurfaceManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Surface(manager, context));
        return manager;
    }

    public static <T extends ModifierManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.BiomeModifier(manager, context));
        return manager;
    }

    public static <T extends LayerManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Layers(manager, context));
        return manager;
    }

    public static <T extends GeologyManager> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Geology(manager, context));
        return manager;
    }

    public static <T extends FeatureModifiers> T setup(T manager, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Features(manager, context));
        return manager;
    }

    public static void setup(List<ColumnDecorator> base, List<ColumnDecorator> feature, GeneratorContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new SetupEvent.Decorators(new DecoratorManager(base, feature), context));
    }
}

