/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.noise.source;

import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.noise.source.Builder;
import com.terraforged.noise.source.NoiseSource;
import com.terraforged.noise.util.Noise;
import com.terraforged.noise.util.NoiseUtil;

public class PerlinNoise
extends NoiseSource {
    private static final float[] signals = new float[]{1.0f, 0.9f, 0.83f, 0.75f, 0.64f, 0.62f, 0.61f};
    protected final float min;
    protected final float max;
    protected final float range;

    public PerlinNoise(Builder builder) {
        super(builder);
        this.min = this.min(builder.getOctaves(), builder.getGain());
        this.max = this.max(builder.getOctaves(), builder.getGain());
        this.range = Math.abs(this.max - this.min);
    }

    @Override
    public String getSpecName() {
        return "Perlin";
    }

    @Override
    public float getValue(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        float sum = 0.0f;
        float amp = this.gain;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Noise.singlePerlin(x, y, this.seed + i, this.interpolation) * amp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.range);
    }

    @Override
    public float getValue(float x, float y, int seed) {
        x *= this.frequency;
        y *= this.frequency;
        float sum = 0.0f;
        float amp = this.gain;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Noise.singlePerlin(x, y, seed + i, this.interpolation) * amp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.range);
    }

    protected float min(int octaves, float gain) {
        return -this.max(octaves, gain);
    }

    protected float max(int octaves, float gain) {
        float signal = PerlinNoise.signal(octaves);
        float sum = 0.0f;
        float amp = gain;
        for (int i = 0; i < octaves; ++i) {
            sum += signal * amp;
            amp *= gain;
        }
        return sum;
    }

    private static float signal(int octaves) {
        int index = Math.min(octaves, signals.length - 1);
        return signals[index];
    }

    public static DataSpec<PerlinNoise> spec() {
        return PerlinNoise.specBuilder("Perlin", PerlinNoise.class, PerlinNoise::new).build();
    }
}

