/*
 * Decompiled with CFR 0.152.
 */
package timeless_and_classic.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="timeless_and_classic", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public enum SpecialModels {
    M1911("m1911"),
    M1911_SLIDE("m1911_slide"),
    M1851("m1851"),
    M1851_CYLINDER("m1851_cylinder"),
    M1851_HAMMER("m1851_hammer");

    private ResourceLocation modelLocation;
    private boolean specialModel;
    @OnlyIn(value=Dist.CLIENT)
    private IBakedModel cachedModel;

    private SpecialModels(String modelName) {
        this(new ResourceLocation("timeless_and_classic", "special/" + modelName), true);
    }

    private SpecialModels(ResourceLocation resourceLocation, boolean specialModel) {
        this.modelLocation = resourceLocation;
        this.specialModel = specialModel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel getModel() {
        if (this.cachedModel == null) {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(this.modelLocation);
            if (model == Minecraft.func_71410_x().func_209506_al().func_174951_a()) {
                return model;
            }
            this.cachedModel = model;
        }
        return this.cachedModel;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void register(ModelRegistryEvent event) {
        for (SpecialModels model : SpecialModels.values()) {
            if (!model.specialModel) continue;
            ModelLoader.addSpecialModel((ResourceLocation)model.modelLocation);
        }
    }
}

