/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.BaseContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;

public abstract class FixedContainerElement
extends BaseContainerElement {
    protected Map<IElement, ElementPosition> elements;
    protected List<IElement> elementsList;
    private ElementPosition size;

    public FixedContainerElement(String id, int xSize, int ySize) {
        super(id);
        this.size = new ElementPosition(xSize, ySize);
        this.elements = new HashMap<IElement, ElementPosition>();
        this.elementsList = new ArrayList<IElement>();
    }

    public final void addElement(IElement ele, int x, int y) {
        if (ele != null) {
            ElementPosition pos = new ElementPosition(x, y);
            this.elements.put(ele, pos);
            this.elementsList.add(ele);
            ele.setOwner(this);
        }
    }

    @Override
    @NotNull
    protected List<IElement> getElementList() {
        return this.elementsList;
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getX();
        }
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getY();
        }
        return 0;
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return null;
    }

    @Override
    public int getSizeX() {
        return this.size.getX();
    }

    @Override
    public int getSizeY() {
        return this.size.getX();
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawBackground(this.elementsList, mouseX, mouseY, partialTicks, this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.drawForeground(this.elementsList, mouseX, mouseY, this);
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elementsList);
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        GuiUtils.drawTooltips(this.elementsList, mouseX, mouseY, this);
    }
}

