/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import com.valkyrieofnight.vlib.core.util.lambda.Action;
import com.valkyrieofnight.vlib.core.util.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static void initContainerAll(@NotNull Collection<IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementContainer) {
                ((IElementContainer)((Object)ele)).initContainer();
            }
        });
    }

    public static int getElementsAddedSizeX(@NotNull Collection<IElement> elements) {
        int sizeX = 0;
        for (IElement ele : elements) {
            sizeX += ele.getSizeX();
        }
        return sizeX;
    }

    public static int getElementsAddedSizeY(@NotNull Collection<IElement> elements) {
        int sizeY = 0;
        for (IElement ele : elements) {
            sizeY += ele.getSizeY();
        }
        return sizeY;
    }

    public static void updateAll(@NotNull Collection<IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementUpdate) {
                ((IElementUpdate)((Object)ele)).update();
            }
        });
    }

    public static void onThemeChangedAll(@NotNull Collection<IElement> elements, Theme theme) {
        elements.forEach(ele -> {
            if (ele instanceof IElementThemeListener) {
                ((IElementThemeListener)((Object)ele)).onThemeChanged(theme);
            }
        });
    }

    public static void drawBackground(@NotNull List<IElement> elements, int mouseX, int mouseY, float partialTicks, IElementContainer container) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isBackgroundVisible()) {
                ((IElementDraw)((Object)ele)).drawBackground(mouseX, mouseY, partialTicks);
            }
        });
    }

    public static void drawForeground(@NotNull List<IElement> elements, int mouseX, int mouseY, IElementContainer container) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isForegroundVisible()) {
                ((IElementDraw)((Object)ele)).drawForeground(mouseX, mouseY);
            }
        });
    }

    public static void drawTooltips(@NotNull List<IElement> elements, int mouseX, int mouseY, IElementContainer container) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDrawTooltip) {
                ((IElementDrawTooltip)((Object)ele)).drawTooltips(mouseX, mouseY);
            }
        });
    }

    public static boolean mouseClickedCheckAll(@NotNull Collection<IElement> elements, double mouseX, double mouseY, int mouseButton, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseX, (int)mouseY);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() && !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).emouseClicked(mouseX, mouseY, mouseButton)) continue;
            r = true;
            container.mouseClickedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return r;
    }

    public static boolean mouseReleasedCheckAll(@NotNull Collection<IElement> elements, double mouseX, double mouseY, int mouseButton, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseX, (int)mouseY);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() && !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).emouseReleased(mouseX, mouseY, mouseButton)) continue;
            r = true;
            container.mouseReleasedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return r;
    }

    public static boolean mouseDraggedCheckAll(@NotNull Collection<IElement> elements, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseXStart, (int)mouseYStart);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() && !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).emouseDragged(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd)) continue;
            r = true;
            container.mouseDraggedResponse(ele, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
        }
        return r;
    }

    public static boolean mouseScrolledCheckAll(@NotNull Collection<IElement> elements, double mx, double my, double scrolled, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mx, (int)my);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() && !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).emouseScrolled(mx, my, scrolled)) continue;
            r = true;
            container.mouseScrolledResponse(ele, mx, my, scrolled);
        }
        return r;
    }

    public static boolean keyPressedCheckAll(@NotNull Collection<IElement> elements, int key, int scanCode, int modifiers, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).ekeyPressed(key, scanCode, modifiers)) continue;
            r = true;
            container.keyPressedResponse(ele, key, scanCode, modifiers);
        }
        return r;
    }

    public static boolean keyReleasedCheckAll(@NotNull Collection<IElement> elements, int key, int scanCode, int modifiers, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).ekeyReleased(key, scanCode, modifiers)) continue;
            r = true;
            container.keyReleasedResponse(ele, key, scanCode, modifiers);
        }
        return r;
    }

    public static boolean charTypedCheckAll(@NotNull Collection<IElement> elements, char ch, int modifiers, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).echarTyped(ch, modifiers)) continue;
            r = true;
            container.charTypedResponse(ele, ch, modifiers);
        }
        return r;
    }

    public static void guiScissorStart(int x, int y, int w, int h) {
        double d = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        int sx = (int)((double)x * d);
        int sy = (int)((double)y * d);
        int sw = (int)((double)w * d);
        int sh = (int)((double)h * d);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    public static void guiScissorEnd() {
        GL11.glDisable((int)3089);
    }

    public static void out(String data) {
        System.out.println(data);
    }

    public static boolean withinBox(int x, int y, int boxX, int boxY, int boxWidth, int boxHeight) {
        return x >= boxX && x < boxX + boxWidth && y >= boxY && y < boxY + boxHeight;
    }

    public static void withinEither(Provider<Boolean> livesOutside, int x, int y, IElement element, Action success) {
        GuiUtils.withinEither(livesOutside, x, y, element.getActualX(), element.getActualY(), element.getSizeX(), element.getSizeY(), element, success);
    }

    public static void withinEitherElse(Provider<Boolean> livesOutside, int x, int y, IElement element, Action success, Action fail) {
        GuiUtils.withinEitherElse(livesOutside, x, y, element.getActualX(), element.getActualY(), element.getSizeX(), element.getSizeY(), element, success, fail);
    }

    public static void withinEither(Provider<Boolean> livesOutside, int x, int y, int boxX, int boxY, int boxWidth, int boxHeight, IElement element, Action success) {
        if (livesOutside.request().booleanValue()) {
            if (GuiUtils.withinBox(x, y, boxX, boxY, boxWidth, boxHeight)) {
                success.execute();
            }
        } else if (element.withinBoxAndGui(x, y, boxX, boxY, boxWidth, boxHeight)) {
            success.execute();
        }
    }

    public static void withinEitherElse(Provider<Boolean> livesOutside, int x, int y, int boxX, int boxY, int boxWidth, int boxHeight, IElement element, Action success, Action fail) {
        if (livesOutside.request().booleanValue()) {
            if (GuiUtils.withinBox(x, y, boxX, boxY, boxWidth, boxHeight)) {
                success.execute();
            } else {
                fail.execute();
            }
        } else if (element.withinBoxAndGui(x, y, boxX, boxY, boxWidth, boxHeight)) {
            success.execute();
        } else {
            fail.execute();
        }
    }

    public static void drawTooltipsList(IElementContainer container, int mouseX, int mouseY, List<ITextComponent> tooltips) {
        GuiUtils.drawTooltipsListString(container, mouseX, mouseY, TextComponentUtil.convertToFormatted(tooltips));
    }

    public static void drawTooltipsListString(IElementContainer container, int mouseX, int mouseY, List<String> tooltips) {
        container.getGui().renderTooltip(tooltips, mouseX - container.getActualX(), mouseY - container.getActualY());
    }

    public static void drawTexturedRect(AbstractGui obj, int x, int y, int u, int v, int uw, int vh) {
        obj.blit(x, y, u, v, uw, vh);
    }

    public static void drawTexturedRect(AbstractGui obj, int x, int y, int u, int v, int uw, int vh, int texWidth, int texHeight) {
        AbstractGui.blit((int)x, (int)y, (float)u, (float)v, (int)uw, (int)vh, (int)texWidth, (int)texHeight);
    }

    public static void drawTexturedRect(AbstractGui obj, int x, int y, int u, int v, int uw, int vh, int rendW, int rendH, int texWidth, int texHeight) {
        AbstractGui.blit((int)x, (int)y, (int)rendW, (int)rendH, (float)u, (float)v, (int)uw, (int)vh, (int)texWidth, (int)texHeight);
    }

    public static void drawTexturedRectRepeat(AbstractGui obj, int x, int y, int u, int v, int uw, int vh, int rendW, int rendH, int texWidth, int texHeight) {
        int cx;
        int yy;
        int xRepeat = rendW / uw;
        int xRepeatR = rendW % uw;
        int yRepeat = rendH / vh;
        int yRepeatR = rendH % vh;
        int currentX = x;
        int currentY = y;
        for (int xx = 0; xx < xRepeat; ++xx) {
            currentX = x + uw * xx;
            for (yy = 0; yy < yRepeat; ++yy) {
                currentY = y + vh * yy;
                GuiUtils.drawTexturedRect(obj, currentX, currentY, u, v, uw, vh, texWidth, texHeight);
            }
        }
        if (xRepeatR > 0) {
            cx = x + xRepeat * uw;
            for (yy = 0; yy < yRepeat; ++yy) {
                int cy = y + vh * yy;
                GuiUtils.drawTexturedRect(obj, cx, cy, u, v, xRepeatR, vh, xRepeatR, vh, texWidth, texHeight);
            }
        }
        if (yRepeatR > 0) {
            int cy = y + yRepeat * vh;
            for (int xx = 0; xx < xRepeat; ++xx) {
                int cx2 = x + uw * xx;
                GuiUtils.drawTexturedRect(obj, cx2, cy, u, v, uw, yRepeatR, uw, yRepeatR, texWidth, texHeight);
            }
        }
        if (xRepeatR > 0 && yRepeatR > 0) {
            cx = x + xRepeat * uw;
            int cy = y + yRepeat * vh;
            GuiUtils.drawTexturedRect(obj, cx, cy, u, v, xRepeatR, yRepeatR, xRepeatR, yRepeatR, texWidth, texHeight);
        }
    }

    public static void drawProgressBar(AbstractGui obj, GuiTexture texture, int x, int y, ProgressionDirection proressDirection, float scale) {
        GuiUtils.bindTexture(texture.texture);
        boolean horizontal = proressDirection == ProgressionDirection.TO_LEFT || proressDirection == ProgressionDirection.TO_RIGHT;
        int xx = proressDirection == ProgressionDirection.TO_LEFT ? texture.width - (int)((float)texture.width * scale) : 0;
        int yy = proressDirection == ProgressionDirection.UPWARD ? texture.height - (int)((float)texture.height * scale) : 0;
        GuiUtils.drawTexturedRect(obj, x + xx, y + yy, texture.startX + xx, texture.startY + yy, horizontal ? (int)((float)texture.width * scale) : texture.width, !horizontal ? (int)((float)texture.height * scale) : texture.height);
    }

    public static void drawGuiTexture(AbstractGui obj, GuiTexture texture, int x, int y, int width, int height) {
        GuiUtils.bindTexture(texture.texture);
        GuiUtils.drawTexturedRect(obj, x, y, texture.startX, texture.startY, texture.width, texture.height, width, height, texture.getTexW(), texture.getTexH());
    }

    public static void enableStandardItemLighting() {
        RenderHelper.func_227780_a_();
    }

    public static void disableStandardItemLighting() {
        RenderHelper.func_74518_a();
    }

    public static void renderTexture(AbstractGui obj, GuiTexture tex, IElementContainer gui, int x, int y) {
        GuiUtils.bindTexture(tex.texture);
        GuiUtils.drawTexturedRect(obj, x, y, tex.startX, tex.startY, tex.width, tex.height);
    }

    public static void renderTexture(AbstractGui obj, GuiTexture tex, IElementContainer gui, int x, int y, int w, int h) {
        GuiUtils.bindTexture(tex.texture);
        GuiUtils.drawTexturedRect(obj, x, y, tex.startX, tex.startY, tex.width, tex.height, w, h);
    }

    protected static void bindTexture(VLID res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)res);
    }
}

