/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.modifier;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.modifier.IModifierTile;
import com.valkyrieofnight.vlib.modifier.attribute.Attribute;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeID;
import com.valkyrieofnight.vlib.modifier.attribute.AttributeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileModifierHandler
implements ITick {
    private TileEntity tile;
    private List<Attribute> scannableAttributes = Lists.newArrayList();
    private boolean needsUpdate = true;
    private List<BlockPos> modifiers = new ArrayList<BlockPos>();
    private Map<AttributeID, Object> finalizedValues = Maps.newHashMap();

    public TileModifierHandler(TileEntity tile) {
        this.tile = tile;
    }

    public void addScannable(AttributeID id) {
        if (!AttributeRegistry.getInstance().hasAttribute(id)) {
            return;
        }
        this.scannableAttributes.add(AttributeRegistry.getInstance().getByID(id));
    }

    public void queueModifiers(List<BlockPos> modifiers) {
        this.modifiers = modifiers;
        this.needsUpdate = true;
    }

    @Override
    public void tick() {
        if (this.needsUpdate) {
            World world = this.tile.func_145831_w();
            HashMap values = Maps.newHashMap();
            for (Attribute attribute : this.scannableAttributes) {
                values.put(attribute, new ArrayList());
            }
            for (BlockPos blockPos : this.modifiers) {
                TileEntity te = world.func_175625_s(blockPos);
                if (!(te instanceof IModifierTile)) continue;
                CompoundNBT nbt = ((IModifierTile)te).getAttributesTag();
                for (Attribute attribute : this.scannableAttributes) {
                    Object o = attribute.readFromNBT(nbt);
                    if (o == null) continue;
                    List l = (List)values.get(attribute.getID());
                    l.add(o);
                }
            }
            for (Attribute attribute : values.keySet()) {
                Object f = attribute.getFinalized((List)values.get(attribute));
                this.finalizedValues.put(attribute.getID(), f);
            }
            this.needsUpdate = false;
        }
    }

    public Object getAttributeFinazliedValue(AttributeID id) {
        if (!this.finalizedValues.containsKey(id)) {
            return null;
        }
        return this.finalizedValues.get(id);
    }
}

