/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.core.io.json.IJsonSerializable;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserRegistry;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropMap;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonConfig
extends PropMap {
    private static Gson gson = new GsonBuilder().registerTypeAdapter(JsonConfig.class, (Object)new JsonConfigParser()).setPrettyPrinting().create();
    private transient String rawLocationJson;
    private transient String rawLocationDocumentation;
    private transient File locationJson;
    private transient File locationDocumentation;

    public JsonConfig(String location) {
        this.rawLocationJson = location;
        if (!this.rawLocationJson.endsWith(".json")) {
            this.rawLocationDocumentation = this.rawLocationDocumentation + ".txt";
            this.rawLocationJson = this.rawLocationJson + ".json";
        } else {
            this.rawLocationDocumentation = StringUtils.removeEnd(this.rawLocationJson, ".json");
            this.rawLocationDocumentation = this.rawLocationDocumentation + ".txt";
        }
        this.locationJson = new File(this.rawLocationJson);
        this.locationDocumentation = new File(this.rawLocationDocumentation);
    }

    public List<String> dumpData() {
        ArrayList sl = Lists.newArrayList();
        for (String key : ((Map)this.data).keySet()) {
            sl.add(key + ": " + ((PropBase)((Map)this.data).get(key)).getValue());
        }
        return sl;
    }

    public void loadConfig() {
        this.data = new LinkedHashMap();
        JsonConfig map = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.locationJson));
            if (reader.ready()) {
                map = (JsonConfig)gson.fromJson((Reader)reader, JsonConfig.class);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map == null) {
            return;
        }
        this.putAll(map);
    }

    public void saveConfig() {
        try {
            this.locationJson.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.locationJson);
            writer.write(gson.toJson((Object)this));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveDocumentation() {
        try {
            this.locationDocumentation.getParentFile().mkdirs();
            OutputStreamWriter outstream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.locationDocumentation), "UTF-8");
            BufferedWriter br = new BufferedWriter(outstream);
            List<String> data = this.getParser().getLocalizedDocumentation(this);
            for (String str : data) {
                br.write(str);
                br.write("\r\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class JsonConfigParser
    extends PropParserBase<JsonConfig>
    implements IJsonSerializable<JsonConfig> {
        public JsonConfigParser() {
            super("jc");
        }

        public JsonElement serialize(JsonConfig src, Type typeOfSrc, JsonSerializationContext context) {
            try {
                return this.toJson(src);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public JsonConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.fromJson(json);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public JsonConfig fromJson(JsonElement json) throws Exception {
            JsonObject jobj = (JsonObject)json;
            JsonConfig pm = new JsonConfig("");
            for (Map.Entry ent : jobj.entrySet()) {
                String key = (String)ent.getKey();
                JsonElement ele = (JsonElement)ent.getValue();
                String[] data = key.split(":");
                if (data.length < 2) continue;
                String pre = data[0];
                String id = data[1];
                PropParserBase pp = PropParserRegistry.getGlobalInstance().getParser(pre);
                if (pp == null) continue;
                PropBase pb = ((PropBase)pp.fromJson(ele)).setId(id);
                ((Map)pm.data).put(pb.generateKey(id), pb);
            }
            return pm;
        }

        @Override
        public JsonElement toJson(JsonConfig prop) throws Exception {
            JsonObject jobj = new JsonObject();
            for (PropBase pb : ((Map)prop.data).values()) {
                PropParserBase pp = pb.getParser();
                if (!pb.isEnabled()) continue;
                String jsonKey = pb.getMapKey();
                String extra = pb.getExtra();
                if (!StringUtils.isNullOrEmpty(extra)) {
                    jsonKey = jsonKey + ":" + extra;
                }
                jobj.add(jsonKey, pp.toJson(pb));
            }
            return jobj;
        }
    }
}

