/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;

public class PropInt
extends PropBase<Integer> {
    public static final PropIntParser PARSER = new PropIntParser();
    protected int min;
    protected int max;

    public PropInt(int value, int min, int max) {
        super(value);
        this.min = min;
        this.max = max;
    }

    public PropInt(int value) {
        this(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public String getExtra() {
        return "[" + this.min + "~" + this.max + "]";
    }

    @Override
    protected Integer validateData(Integer data) {
        return MathUtil.clamp(data, this.min, this.max);
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static class PropIntParser
    extends PropParserBase<PropInt> {
        public PropIntParser() {
            super("in");
        }

        @Override
        public PropInt fromJson(@NotNull JsonElement json) throws Exception {
            return new PropInt(json.getAsInt());
        }

        @Override
        public JsonElement toJson(@NotNull PropInt prop) throws Exception {
            return new JsonPrimitive((Number)prop.getValue());
        }
    }
}

