/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.block.withtile;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.obj.block.VLBlock;
import com.valkyrieofnight.vlib.core.obj.block.base.BlockProps;
import com.valkyrieofnight.vlib.core.obj.block.base.color.IColorProviderBlock;
import com.valkyrieofnight.vlib.core.obj.block.base.color.IColorableBlockWithTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IOnDrop;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IOnPlacedBy;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IOnPlayerWillDestroy;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IOnUse;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IProvideGui;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.ISaveTypedData;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorableTile;
import com.valkyrieofnight.vlib.core.util.NetworkUtils;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class VLTileBlock
extends VLBlock {
    private final Class<? extends TileEntity> tile;

    public VLTileBlock(VLID id, BlockProps props, Class<? extends TileEntity> tile) {
        super(id, props);
        this.tile = tile;
    }

    @Deprecated
    public BlockRenderType getRenderType(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        try {
            return this.tile.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        Block block = state.func_177230_c();
        if (te instanceof ISaveTypedData && stack.func_77942_o()) {
            ((ISaveTypedData)te).load(stack.func_196082_o(), SaveDataType.ITEM);
        }
        if (te instanceof IOnPlacedBy && placer instanceof PlayerEntity) {
            ((IOnPlacedBy)te).onPlacedBy((PlayerEntity)placer);
        }
        if (block instanceof IColorableBlockWithTile && te instanceof IColorableTile) {
            int[] channels = ((IColorableBlockWithTile)block).getAllColorableChannels();
            for (int i = 0; i < channels.length; ++i) {
                int channel = channels[i];
                ((IColorableTile)te).setColor(channel, ((IColorProviderBlock)block).getColor(stack, channel));
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_176208_a(World w, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity te = w.func_175625_s(pos);
        if (te instanceof IOnPlayerWillDestroy) {
            ((IOnPlayerWillDestroy)te).onPlayerWillDestroy(player);
        }
        super.func_176208_a(w, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ISaveTypedData saveTile;
        CompoundNBT nbt;
        ArrayList drops = Lists.newArrayList();
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        ItemStack tileDrop = new ItemStack((IItemProvider)this);
        if (te instanceof IOnDrop) {
            ((IOnDrop)te).onDrop();
        }
        if (te instanceof ISaveTypedData && !(nbt = (saveTile = (ISaveTypedData)te).save(new CompoundNBT(), SaveDataType.ITEM)).isEmpty()) {
            tileDrop.func_77982_d(nbt);
        }
        drops.add(tileDrop);
        drops.addAll(super.func_220076_a(state, builder));
        return drops;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ActionResultType ret = null;
        TileEntity te = worldIn.func_175625_s(pos);
        if (worldIn.func_201670_d()) {
            if (te instanceof IOnUse && ((IOnUse)te).canUse(state, worldIn, pos, player, handIn, hit)) {
                ret = ActionResultType.SUCCESS;
            }
            if (te instanceof IProvideGui && ((IProvideGui)te).shouldOpenGui(state, worldIn, pos, player, handIn, hit)) {
                ret = ActionResultType.SUCCESS;
            }
        } else {
            if (te instanceof IOnUse && ((IOnUse)te).canUse(state, worldIn, pos, player, handIn, hit)) {
                ret = ((IOnUse)te).use(state, worldIn, pos, player, handIn, hit);
            }
            if (te instanceof IProvideGui && ((IProvideGui)te).shouldOpenGui(state, worldIn, pos, player, handIn, hit) && !player.func_213453_ef()) {
                NetworkUtils.openGui((ServerPlayerEntity)player, this, (windowID, playerInv, playerEntity) -> ((IProvideGui)te).createContainer((int)windowID, (PlayerEntity)playerEntity, te), packetBuffer -> packetBuffer.func_179255_a(pos));
                ret = ActionResultType.SUCCESS;
            }
        }
        return ret == null ? ActionResultType.FAIL : ret;
    }

    public ItemStack getPickBlock(BlockState s, RayTraceResult t, IBlockReader w, BlockPos p, PlayerEntity plr) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntity te = w.func_175625_s(p);
        if (te instanceof ISaveTypedData) {
            CompoundNBT nbt = ((ISaveTypedData)te).save(new CompoundNBT(), SaveDataType.ITEM);
            stack.func_77982_d(nbt);
        }
        return stack;
    }
}

