/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container;

import com.valkyrieofnight.vlib.core.obj.container.IIOHandler;
import com.valkyrieofnight.vlib.core.util.enums.EnumIO;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class IOHandler
implements IIOHandler {
    protected final IInventory ioSlots;
    protected final Action setChangedMethod;
    protected EnumIO ioMode;
    protected int inputSlotIndex = 0;
    protected int bufferSlotIndex = 1;
    protected int outputSlotIndex = 2;
    private boolean ignoreInternalStorageInputRate = false;
    private boolean ignoreInternalStorageOutputRate = false;
    private boolean ignoreItemInputRate = false;
    private boolean ignoreItemOutputRate = false;

    public IOHandler(IInventory ioSlots, EnumIO ioMode) {
        this(ioSlots, ioMode, () -> {});
    }

    public IOHandler(IInventory ioSlots, EnumIO ioMode, Action setChangedMethod) {
        this.ioSlots = ioSlots;
        this.ioMode = ioMode;
        this.setChangedMethod = setChangedMethod;
    }

    @Override
    public void toggleIOMode() {
        this.ioMode = this.ioMode == EnumIO.INPUT ? EnumIO.OUTPUT : EnumIO.INPUT;
    }

    @Override
    public EnumIO getIOMode() {
        return this.ioMode;
    }

    @Override
    public void ignoreInternalStorageInputRate(boolean ignore) {
        this.ignoreInternalStorageInputRate = ignore;
    }

    @Override
    public void ignoreInternalStorageOutputRate(boolean ignore) {
        this.ignoreInternalStorageOutputRate = ignore;
    }

    @Override
    public void ignoreItemStorageInputRate(boolean ignore) {
        this.ignoreItemInputRate = ignore;
    }

    @Override
    public void ignoreItemStorageOutputRate(boolean ignore) {
        this.ignoreItemOutputRate = ignore;
    }

    @Override
    public boolean isInternalStorageInputRateIgnored() {
        return this.ignoreInternalStorageInputRate;
    }

    @Override
    public boolean isInternalStorageOutputRateIgnored() {
        return this.ignoreInternalStorageOutputRate;
    }

    @Override
    public boolean isItemInputRateIgnored() {
        return this.ignoreItemInputRate;
    }

    @Override
    public boolean isItemOutputRateIgnored() {
        return this.ignoreItemOutputRate;
    }

    @Override
    public void setInputSlotIndex(int index) {
        this.inputSlotIndex = index;
    }

    @Override
    public void setBufferSlotIndex(int index) {
        this.bufferSlotIndex = index;
    }

    @Override
    public void setOutputSlotIndex(int index) {
        this.outputSlotIndex = index;
    }

    @Override
    public void tick() {
        if (this.canProcess()) {
            ItemStack bufferSlotItemStack;
            if (this.ioSlots.func_70301_a(this.bufferSlotIndex).func_190926_b() && !InventoryUtils.moveItem(this.ioSlots, this.inputSlotIndex, this.bufferSlotIndex, this.howManyItemsToProcessPerBufferSlot(), false).func_190926_b()) {
                this.setChangedMethod.execute();
            }
            if (!(bufferSlotItemStack = this.ioSlots.func_70301_a(this.bufferSlotIndex)).func_190926_b()) {
                if (this.canItemBeProcessed(bufferSlotItemStack)) {
                    if (this.processItem(bufferSlotItemStack)) {
                        InventoryUtils.moveItem(this.ioSlots, this.bufferSlotIndex, this.outputSlotIndex, 1, false);
                    }
                } else {
                    InventoryUtils.moveItem(this.ioSlots, this.bufferSlotIndex, this.outputSlotIndex, this.howManyItemsToProcessPerBufferSlot(), false);
                }
                this.setChangedMethod.execute();
            }
        }
    }
}

