/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity;

import com.valkyrieofnight.vlib.core.obj.tileentity.base.IVLTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.protection.PlayerID;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class VLTileEntity
extends TileEntity
implements IVLTile {
    protected PlayerID placedBy = PlayerID.EMPTY;

    public VLTileEntity(TileEntityType<?> blockEntityType_1) {
        super(blockEntityType_1);
    }

    protected PlayerID getPlacedBy() {
        return this.placedBy;
    }

    @Override
    public final void onPlacedBy(PlayerEntity player) {
        this.placedBy = new PlayerID(player.func_146103_bH().getId());
    }

    @Nullable
    public final SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.save(nbt, SaveDataType.TO_CLIENT);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public final void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.load(pkt.func_148857_g(), SaveDataType.FROM_SERVER);
    }

    public final CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74757_a("from_server", true);
        this.save(nbt, SaveDataType.TO_CLIENT);
        return nbt;
    }

    public final void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public final void func_70296_d() {
        super.func_70296_d();
        BlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
    }

    public final CompoundNBT func_189515_b(CompoundNBT nbt) {
        CompoundNBT retN = nbt == null ? new CompoundNBT() : nbt;
        this.save(retN, SaveDataType.TILE);
        return super.func_189515_b(retN);
    }

    public final void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt != null) {
            if (nbt.func_74764_b("from_server")) {
                this.load(nbt, SaveDataType.FROM_SERVER);
            } else {
                this.load(nbt, SaveDataType.TILE);
            }
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (!PlayerID.EMPTY.equals(this.placedBy) && type != SaveDataType.ITEM) {
            nbt.func_218657_a("placedby", (INBT)this.placedBy.serializeNBT());
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("placedby")) {
            this.placedBy = PlayerID.fromNBT(nbt.func_74775_l("placedby"));
        }
    }

    protected IItemHandler createUnSidedHandler(Direction side) {
        return new SidedInvWrapper((ISidedInventory)this, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof ISidedInventory) {
            return LazyOptional.of(() -> this.createUnSidedHandler(side));
        }
        return super.getCapability(cap, side);
    }
}

