/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.base.tick;

import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.tick.TickCounter;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import net.minecraft.nbt.CompoundNBT;

public class TickTracker
implements INBTSerializer {
    private TickCounter counter = new TickCounter();
    private Provider<Boolean> canProcessStart;
    private Provider<Boolean> canProcessTick;
    private Provider<Boolean> canProcessComplete;
    private Action onProcessStart;
    private Action onProcessTick;
    private Action onProcessIdleTick;
    private Action onProcessComplete;
    private Provider<Integer> getProcessDuration;

    private TickTracker() {
    }

    public void tick() {
        if (this.counter.hasStarted() && !this.counter.isComplete()) {
            if (this.canProcessTick.request().booleanValue()) {
                this.onProcessTick.execute();
                this.counter.tick();
            } else {
                this.onProcessIdleTick.execute();
            }
        }
        if (!this.counter.hasStarted()) {
            this.startNewProcess();
        } else if (this.counter.isComplete() && this.canProcessComplete.request().booleanValue()) {
            this.onProcessComplete.execute();
            this.counter.reset(0);
        }
    }

    private void startNewProcess() {
        if (this.canProcessStart.request().booleanValue()) {
            this.counter.reset(this.getProcessDuration.request());
            this.onProcessStart.execute();
            this.counter.start();
        }
    }

    public boolean hasStarted() {
        return this.counter.hasStarted();
    }

    public int getCurrentDuration() {
        return this.counter.getDuration();
    }

    public int getCurrentProgress() {
        return this.counter.getProgress();
    }

    @Override
    public CompoundNBT serializeNBT() {
        return this.counter.serializeNBT();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.counter.deserializeNBT(nbt);
    }

    public static class Builder {
        private Provider<Boolean> canProcessStart;
        private Provider<Boolean> canProcessTick;
        private Provider<Boolean> canProcessComplete;
        private Action onProcessStart;
        private Action onProcessTick;
        private Action onProcessIdleTick;
        private Action onProcessComplete;
        private Provider<Integer> getProcessDuration;

        public static Builder create() {
            return new Builder();
        }

        public Builder setCanProcessStartProvider(Provider<Boolean> provider) {
            this.canProcessStart = provider;
            return this;
        }

        public Builder setCanProcessTickProvider(Provider<Boolean> provider) {
            this.canProcessTick = provider;
            return this;
        }

        public Builder setCanProcessCompleteProvider(Provider<Boolean> provider) {
            this.canProcessComplete = provider;
            return this;
        }

        public Builder setOnProcessStartAction(Action action) {
            this.onProcessStart = action;
            return this;
        }

        public Builder setOnProcessTickAction(Action action) {
            this.onProcessTick = action;
            return this;
        }

        public Builder setOnProcessIdleTickAction(Action action) {
            this.onProcessIdleTick = action;
            return this;
        }

        public Builder setOnProcessCompleteAction(Action action) {
            this.onProcessComplete = action;
            return this;
        }

        public Builder setGetProcessDurationProvider(Provider<Integer> provider) {
            this.getProcessDuration = provider;
            return this;
        }

        public TickTracker build() {
            TickTracker tracker = new TickTracker();
            tracker.canProcessStart = this.canProcessStart != null ? this.canProcessStart : () -> true;
            tracker.canProcessTick = this.canProcessTick != null ? this.canProcessTick : () -> true;
            tracker.canProcessComplete = this.canProcessComplete != null ? this.canProcessComplete : () -> true;
            tracker.onProcessStart = this.onProcessStart != null ? this.onProcessStart : () -> {};
            tracker.onProcessTick = this.onProcessTick != null ? this.onProcessTick : () -> {};
            tracker.onProcessIdleTick = this.onProcessIdleTick != null ? this.onProcessIdleTick : () -> {};
            tracker.onProcessComplete = this.onProcessComplete != null ? this.onProcessComplete : () -> {};
            if (this.getProcessDuration == null) {
                throw new NullPointerException("Process Duration cannot be null inside a TickTracker");
            }
            tracker.getProcessDuration = this.getProcessDuration;
            return tracker;
        }
    }
}

