/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.module;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.ISaveTypedData;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleTick;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.ISidedTickerModule;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;

public class Module
implements IModuleTick,
ISaveTypedData {
    protected volatile CopyOnWriteArrayList<? extends Module> modules;

    protected Module() {
    }

    @Override
    public <T extends TileEntity> void tick(T te) {
        this.modules.forEach((Consumer<? extends Module>)((Consumer<Module>)m -> m.tick(te)));
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        this.modules.forEach((Consumer<? extends Module>)((Consumer<Module>)m -> m.save(nbt, type)));
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        this.modules.forEach((Consumer<? extends Module>)((Consumer<Module>)m -> m.load(nbt, type)));
    }

    public static abstract class AbstractBuilder<MODULE extends Module, BUILDER extends AbstractBuilder<MODULE, ?>>
    implements IModuleBuilder<MODULE, BUILDER> {
        protected List<Module> subModules = Lists.newArrayList();
        protected Action1a<MODULE> onModuleInit;

        protected AbstractBuilder() {
        }

        public BUILDER init(Action1a<MODULE> provider) {
            this.onModuleInit = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER addModule(IModuleBuilder<? extends Module, ? extends AbstractBuilder> builder) {
            if (builder != null) {
                Module m = builder.build();
                this.subModules.add(m);
                if (m instanceof ISidedTickerModule) {
                    throw new RuntimeException("Warning a Module that implements ISidedTickerModule was added to a module without ISidedTickerModule functionality");
                }
            }
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        @Override
        public final MODULE build() {
            MODULE m = this.addInternals(this.newModule());
            if (this.onModuleInit != null) {
                this.onModuleInit.execute(m);
            }
            return m;
        }

        protected abstract MODULE newModule();

        protected MODULE addInternals(MODULE module) {
            ((Module)module).modules = Lists.newCopyOnWriteArrayList(this.subModules);
            return module;
        }
    }

    public static final class Builder
    extends AbstractBuilder<Module, Builder> {
        protected Builder() {
        }

        @Override
        protected Module newModule() {
            return new Module();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }
    }
}

