/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.module;

import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.tick.TickCounter;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.SidedTickerModule;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TrackerModule
extends SidedTickerModule {
    protected volatile TickCounter counter = new TickCounter();
    protected volatile Provider<Boolean> canStartProcess;
    protected volatile Function1a<Integer, Integer> validateProcessable;
    protected volatile Provider<Boolean> canCompleteProcess;
    protected volatile Action onProcessStarted;
    protected volatile Action1a<Integer> onProcessTicks;
    protected volatile Action onIdleTick;
    protected volatile Action onComplete;
    protected volatile Provider<Integer> getMaxTickRate;
    protected volatile Provider<Integer> getProcessDuration;
    protected volatile Function1a<SaveDataType, Boolean> validSaveDataTypes;

    protected TrackerModule() {
    }

    @Override
    public void serverTick() {
        if (!this.counter.hasStarted() && !this.counter.isComplete()) {
            this.startNewProcess();
        }
        if (this.counter.hasStarted()) {
            int ticks = this.counter.clampTicks(this.getMaxTickRate());
            if ((ticks = this.validateProcessable(ticks)) > 0) {
                this.counter.tick(ticks);
                this.onProcessTicks(ticks);
            } else {
                this.onIdleTick();
            }
        }
        if (this.counter.isComplete() && this.canCompleteProcess()) {
            this.counter.reset(0);
            this.onCompleteProcess();
        }
    }

    @Override
    public void clientTick() {
    }

    @Override
    public void commonTick() {
    }

    protected void startNewProcess() {
        if (this.canStartProcess()) {
            this.onProcessStarted();
            this.counter.reset(this.getProcessDuration());
            this.counter.start();
        }
    }

    protected int getProcessDuration() {
        return this.getProcessDuration.request();
    }

    protected boolean canStartProcess() {
        return this.canStartProcess.request();
    }

    protected void onProcessStarted() {
        this.onProcessStarted.execute();
    }

    protected int getMaxTickRate() {
        return this.getMaxTickRate.request();
    }

    protected int validateProcessable(int ticks) {
        return this.validateProcessable.execute(ticks);
    }

    protected void onProcessTicks(int ticks) {
        this.onProcessTicks.execute(ticks);
    }

    protected void onIdleTick() {
        this.onIdleTick.execute();
    }

    protected boolean canCompleteProcess() {
        return this.canCompleteProcess.request();
    }

    protected void onCompleteProcess() {
        this.onComplete.execute();
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (this.validSaveDataTypes.execute(type).booleanValue()) {
            nbt.func_218657_a("counter", (INBT)this.counter.serializeNBT());
        }
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (this.validSaveDataTypes.execute(type).booleanValue() && nbt.func_74764_b("counter")) {
            this.counter.deserializeNBT(nbt.func_74775_l("counter"));
        }
        super.load(nbt, type);
    }

    public void reset() {
        this.counter.reset(0);
    }

    public boolean hasStarted() {
        return this.counter.hasStarted();
    }

    public int getCurrentDuration() {
        return this.counter.getDuration();
    }

    public int getCurrentProgress() {
        return this.counter.getProgress();
    }

    public float getProgressScale() {
        return (float)this.getCurrentProgress() / (float)this.getCurrentDuration();
    }

    public static abstract class AbstractBuilder<MODULE extends TrackerModule, BUILDER extends AbstractBuilder<MODULE, BUILDER>>
    extends SidedTickerModule.AbstractBuilder<MODULE, BUILDER> {
        protected volatile Provider<Boolean> canStartProcess;
        protected volatile Function1a<Integer, Integer> validateProcessable;
        protected volatile Provider<Boolean> canCompleteProcess;
        protected volatile Action onProcessStarted;
        protected volatile Action1a<Integer> onProcessTicks;
        protected volatile Action onIdleTick;
        protected volatile Action onComplete;
        protected volatile Provider<Integer> getMaxTickRate;
        protected volatile Provider<Integer> getProcessDuration;
        protected volatile Function1a<SaveDataType, Boolean> validSaveDataTypes;

        protected AbstractBuilder() {
        }

        @Override
        protected MODULE addInternals(MODULE module) {
            ((TrackerModule)module).canStartProcess = this.canStartProcess != null ? this.canStartProcess : () -> true;
            ((TrackerModule)module).validateProcessable = this.validateProcessable != null ? this.validateProcessable : t -> t;
            ((TrackerModule)module).canCompleteProcess = this.canCompleteProcess != null ? this.canCompleteProcess : () -> true;
            ((TrackerModule)module).onProcessStarted = this.onProcessStarted != null ? this.onProcessStarted : () -> {};
            ((TrackerModule)module).onProcessTicks = this.onProcessTicks != null ? this.onProcessTicks : i -> {};
            ((TrackerModule)module).onIdleTick = this.onIdleTick != null ? this.onIdleTick : () -> {};
            ((TrackerModule)module).onComplete = this.onComplete != null ? this.onComplete : () -> {};
            ((TrackerModule)module).getMaxTickRate = this.getMaxTickRate != null ? this.getMaxTickRate : () -> 1;
            Function1a<SaveDataType, Boolean> function1a = ((TrackerModule)module).validSaveDataTypes = this.validSaveDataTypes != null ? this.validSaveDataTypes : sdt -> true;
            if (this.getProcessDuration == null) {
                throw new NullPointerException("Process Duration cannot be null inside TrackerModule");
            }
            ((TrackerModule)module).getProcessDuration = this.getProcessDuration;
            return (MODULE)((TrackerModule)super.addInternals(module));
        }

        public BUILDER canStartProcess(Provider<Boolean> provider) {
            this.canStartProcess = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER checkAndValidateProcessable(Function1a<Integer, Integer> function) {
            this.validateProcessable = function;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER canCompleteProcess(Provider<Boolean> provider) {
            this.canCompleteProcess = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onProcessStarted(Action action) {
            this.onProcessStarted = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onProcessTick(Action1a<Integer> action) {
            this.onProcessTicks = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onIdleTick(Action action) {
            this.onIdleTick = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onComplete(Action action) {
            this.onComplete = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER maxTickRate(Provider<Integer> provider) {
            this.getMaxTickRate = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER processDuration(Provider<Integer> provider) {
            this.getProcessDuration = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER validSaveDataType(Function1a<SaveDataType, Boolean> function) {
            this.validSaveDataTypes = function;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }
    }

    public static final class Builder
    extends AbstractBuilder<TrackerModule, Builder> {
        protected Builder() {
        }

        @Override
        protected TrackerModule newModule() {
            return new TrackerModule();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }
    }
}

