/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.protection;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class PlayerID
implements INBTSerializer {
    public static final PlayerID EMPTY = new PlayerID();
    protected UUID uuid;
    protected String username;

    private PlayerID() {
        this.uuid = null;
        this.username = "";
    }

    public PlayerID(@NotNull UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public PlayerID(@NotNull UUID uuid) {
        this(uuid, "");
    }

    public PlayerID(@NotNull GameProfile profile) {
        this(profile.getId(), profile.getName());
    }

    public boolean isPlayer(PlayerEntity playerEntity) {
        return playerEntity != null ? playerEntity.func_146103_bH().getId().equals(this.uuid) : false;
    }

    public UUID toUUID() {
        return this.uuid;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerID)) {
            return false;
        }
        UUID id = ((PlayerID)obj).toUUID();
        return id == null ? this.uuid == null : id.equals(this.uuid);
    }

    public int hashCode() {
        if (this.uuid == null) {
            return 0;
        }
        return this.uuid.hashCode();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.uuid != null) {
            nbt.func_74772_a("own_mst", this.uuid.getMostSignificantBits());
            nbt.func_74772_a("own_lst", this.uuid.getLeastSignificantBits());
        }
        nbt.func_74778_a("own_un", this.username);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("own_mst") && nbt.func_74764_b("own_lst")) {
            this.uuid = new UUID(nbt.func_74763_f("own_mst"), nbt.func_74763_f("own_lst"));
            this.username = nbt.func_74779_i("own_un");
        }
    }

    public static PlayerID fromNBT(CompoundNBT nbt) {
        PlayerID pid = null;
        if (nbt.func_74764_b("own_mst") && nbt.func_74764_b("own_lst")) {
            UUID id = new UUID(nbt.func_74763_f("own_mst"), nbt.func_74763_f("own_lst"));
            String un = nbt.func_74779_i("own_un");
            pid = new PlayerID(id, un);
        }
        return pid != null ? pid : EMPTY;
    }

    public static void writeToPacket(PacketBuffer packet, PlayerID playerID) {
        packet.func_150786_a(playerID.serializeNBT());
    }

    public static PlayerID readFromPacket(PacketBuffer packetBuffer) {
        PlayerID id = new PlayerID();
        id.deserializeNBT(packetBuffer.func_150793_b());
        return id;
    }
}

