/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.button;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.EnumElementState;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.text.LabelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TextButton
extends ContainerButtonElement {
    protected LabelElement eText = new LabelElement("e", (ITextComponent)new StringTextComponent(""), StandardThemeAssets.COL_BUTTON_TEXT_ENABLED);
    protected LabelElement dText = new LabelElement("d", (ITextComponent)new StringTextComponent(""), StandardThemeAssets.COL_BUTTON_TEXT_DISABLED);
    protected LabelElement hText = new LabelElement("h", (ITextComponent)new StringTextComponent(""), StandardThemeAssets.COL_BUTTON_TEXT_HOVER);
    protected LabelElement sText = new LabelElement("s", (ITextComponent)new StringTextComponent(""), StandardThemeAssets.COL_BUTTON_TEXT_SELECTED);
    protected SizableBGElement ebg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA);
    protected SizableBGElement dbg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS);
    protected SizableBGElement hbg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_HOV);
    protected SizableBGElement sbg = new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_SEL);

    public TextButton(String id, int xSize, int ySize) {
        super(id, xSize, ySize);
    }

    public void setText(ITextComponent enabledText, ITextComponent disabledText, ITextComponent hoverText, ITextComponent selectedText) {
        this.eText.setText(enabledText);
        this.dText.setText(disabledText);
        this.hText.setText(hoverText);
        this.sText.setText(selectedText);
    }

    public void setText(ITextComponent allText) {
        this.eText.setText(allText);
        this.dText.setText(allText);
        this.hText.setText(allText);
        this.sText.setText(allText);
    }

    public void setTextColors(AssetID colorEnabled, AssetID colorDisabled, AssetID colorHover, AssetID colorSelected) {
        this.eText.setColor(colorEnabled);
        this.dText.setColor(colorDisabled);
        this.hText.setColor(colorHover);
        this.sText.setColor(colorSelected);
    }

    public void setTextColors(AssetID allColor) {
        this.eText.setColor(allColor);
        this.dText.setColor(allColor);
        this.hText.setColor(allColor);
        this.sText.setColor(allColor);
    }

    protected ContainerButtonElement setBG(@Nullable AssetID enabled, @Nullable AssetID disabled, @Nullable AssetID hover, @Nullable AssetID selected) {
        if (enabled != null) {
            this.ebg.setBox(enabled);
        }
        if (disabled != null) {
            this.dbg.setBox(disabled);
        }
        if (hover != null) {
            this.hbg.setBox(hover);
        }
        if (selected != null) {
            this.sbg.setBox(selected);
        }
        return this;
    }

    public TextButton setEnabledButtonBackground(AssetID sizableBGElement) {
        this.ebg.setBox(sizableBGElement);
        return this;
    }

    public TextButton setDisabledButtonBackground(AssetID sizableBGElement) {
        this.dbg.setBox(sizableBGElement);
        return this;
    }

    public TextButton setHoveredButtonBackground(AssetID sizableBGElement) {
        this.hbg.setBox(sizableBGElement);
        return this;
    }

    public TextButton setSelectedButtonBackground(AssetID sizableBGElement) {
        this.sbg.setBox(sizableBGElement);
        return this;
    }

    public TextButton setButtonBackground(EnumElementState state, AssetID sizableBGElement) {
        switch (state) {
            case ENABLED: {
                return this.setEnabledButtonBackground(sizableBGElement);
            }
            case DISABLED: {
                return this.setDisabledButtonBackground(sizableBGElement);
            }
            case HOVER: {
                return this.setHoveredButtonBackground(sizableBGElement);
            }
            case SELECTED: {
                return this.setSelectedButtonBackground(sizableBGElement);
            }
        }
        return this;
    }

    public TextButton setEnabledText(ITextComponent textComponent) {
        this.eText.setText(textComponent);
        return this;
    }

    public TextButton setDisabledText(ITextComponent textComponent) {
        this.dText.setText(textComponent);
        return this;
    }

    public TextButton setHoveredText(ITextComponent textComponent) {
        this.hText.setText(textComponent);
        return this;
    }

    public TextButton setSelectedText(ITextComponent textComponent) {
        this.sText.setText(textComponent);
        return this;
    }

    public TextButton setText(EnumElementState state, ITextComponent textComponent) {
        switch (state) {
            case ENABLED: {
                return this.setEnabledText(textComponent);
            }
            case DISABLED: {
                return this.setDisabledText(textComponent);
            }
            case HOVER: {
                return this.setHoveredText(textComponent);
            }
            case SELECTED: {
                return this.setSelectedText(textComponent);
            }
        }
        return this;
    }

    public TextButton setEnabledTextColor(AssetID color) {
        this.eText.setColor(color);
        return this;
    }

    public TextButton setDisabledTextColor(AssetID color) {
        this.dText.setColor(color);
        return this;
    }

    public TextButton setHoveredTextColor(AssetID color) {
        this.hText.setColor(color);
        return this;
    }

    public TextButton setSelectedTextColor(AssetID color) {
        this.sText.setColor(color);
        return this;
    }

    @Deprecated
    public TextButton setTextColor(EnumElementState state, AssetID color) {
        switch (state) {
            case ENABLED: {
                return this.setEnabledTextColor(color);
            }
            case DISABLED: {
                return this.setDisabledTextColor(color);
            }
            case HOVER: {
                return this.setHoveredTextColor(color);
            }
            case SELECTED: {
                return this.setSelectedTextColor(color);
            }
        }
        return this;
    }

    @Deprecated
    public TextButton setEnabledTextColor(Color4 color) {
        this.eText.setColor(color);
        return this;
    }

    @Deprecated
    public TextButton setDisabledTextColor(Color4 color) {
        this.dText.setColor(color);
        return this;
    }

    @Deprecated
    public TextButton setHoveredTextColor(Color4 color) {
        this.hText.setColor(color);
        return this;
    }

    @Deprecated
    public TextButton setSelectedTextColor(Color4 color) {
        this.sText.setColor(color);
        return this;
    }

    @Deprecated
    public TextButton setTextColor(EnumElementState state, Color4 color) {
        switch (state) {
            case ENABLED: {
                return this.setEnabledTextColor(color);
            }
            case DISABLED: {
                return this.setDisabledTextColor(color);
            }
            case HOVER: {
                return this.setHoveredTextColor(color);
            }
            case SELECTED: {
                return this.setSelectedTextColor(color);
            }
        }
        return this;
    }

    @Override
    public void addElements() {
        int cx = this.xSize / 2;
        int cy = this.ySize / 2;
        this.addElementEach(this.ebg, this.dbg, this.hbg, this.sbg, 0, 0);
        this.eText.setHorizontalAlignment(HAlignment.CENTER).setVerticalAlignment(VAlignment.CENTER);
        this.dText.setHorizontalAlignment(HAlignment.CENTER).setVerticalAlignment(VAlignment.CENTER);
        this.hText.setHorizontalAlignment(HAlignment.CENTER).setVerticalAlignment(VAlignment.CENTER);
        this.sText.setHorizontalAlignment(HAlignment.CENTER).setVerticalAlignment(VAlignment.CENTER);
        this.addElementEnabled(this.eText, cx, cy);
        this.addElementDisabled(this.dText, cx, cy);
        this.addElementHover(this.hText, cx, cy);
        this.addElementFocused(this.sText, cx, cy);
    }
}

