/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.image;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.ImageElement;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;

public class MaxScaledImageElement
extends ImageElement {
    protected int maxX;
    protected int maxY;

    public MaxScaledImageElement(String id, AssetID imageID, int xSizeMax, int ySizeMax, AssetID colorID) {
        super(id, imageID, colorID);
        this.maxX = xSizeMax;
        this.maxY = ySizeMax;
    }

    public MaxScaledImageElement(String id, AssetID imageID, int xSizeMax, int ySizeMax) {
        super(id, imageID);
        this.maxX = xSizeMax;
        this.maxY = ySizeMax;
    }

    public void setMaxSize(int xSizeMax, int ySizeMax) {
        this.maxX = xSizeMax;
        this.maxY = ySizeMax;
        float ra = (float)xSizeMax / (float)this.image.width;
        float rb = (float)ySizeMax / (float)this.image.height;
        float rc = Math.min(ra, rb);
        this.xSize = (int)((float)this.image.width * rc);
        this.ySize = (int)((float)this.image.height * rc);
    }

    @Override
    public void onThemeChanged(Theme current) {
        super.onThemeChanged(current);
        this.image = current.getTexture(this.imageID);
        this.setMaxSize(this.maxX, this.maxY);
    }
}

