/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig;

import com.valkyrieofnight.vlib.VLib;
import com.valkyrieofnight.vlib.core.obj.container.config.ISidedConfigurable;
import com.valkyrieofnight.vlib.core.obj.container.config.SidedConfigPacket;
import com.valkyrieofnight.vlib.core.obj.container.config.SidedConfigWL;
import com.valkyrieofnight.vlib.core.ui.client.VLContainerScreen;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.IndexElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizableBGElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.ContainerButtonElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.MaxScaledImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.SequenceImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig.ISidedConfigElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig.SlotConfigArrayElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig.TankConfigArrayElement;
import com.valkyrieofnight.vlib.core.ui.container.VLContainer;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SidedConfigContainerElement
extends FixedContainerElement
implements ISidedConfigElement {
    protected VLContainerScreen screen;
    protected VLContainer container;
    protected TileEntity tile;
    protected ButtonElement configure;
    protected SequenceImageElement configuring;
    protected IndexElement mode;
    protected Provider<Integer> gx;
    protected Provider<Integer> gy;
    protected int buttonX;
    protected int buttonY;
    protected SlotConfigArrayElement invConfig;
    protected TankConfigArrayElement tankConfig;

    public SidedConfigContainerElement(String id, VLContainerScreen screen, VLContainer container, TileEntity tile, int buttonX, int buttonY) {
        super(id, 0, 0);
        this.screen = screen;
        this.container = container;
        this.gx = screen::getSizeX;
        this.gy = screen::getSizeY;
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        this.tile = tile;
    }

    @Override
    public boolean livesOutsideContainer() {
        return true;
    }

    @Override
    public void addElements() {
        this.configure = new ContainerButtonElement("toggle", 12, 12){

            @Override
            public void addElements() {
                this.addElementEach(new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_ENA), new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_DIS), new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_HOV), new SizableBGElement("bg", StandardThemeAssets.GSB_VANILLA_MAIN_BUTTON_SEL), 0, 0);
            }

            @Override
            public boolean livesOutsideContainer() {
                return true;
            }
        };
        this.addElement(this.configure, this.buttonX, this.buttonY);
        this.configure.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.sideconfig")));
        this.mode = new IndexElement("toggle_index"){

            @Override
            public void addIndices() {
                this.addIndex(new FixedContainerElement("off", 0, 0){

                    @Override
                    public void addElements() {
                        this.addElement(new MaxScaledImageElement("off", StandardThemeAssets.TEX_VANILLA_SIDE_CONFIG_ICON_DIS, 8, 8), SidedConfigContainerElement.this.buttonX + 2, SidedConfigContainerElement.this.buttonY + 2);
                    }

                    @Override
                    public int getSizeX() {
                        return SidedConfigContainerElement.this.gx.request();
                    }

                    @Override
                    public int getSizeY() {
                        return SidedConfigContainerElement.this.gy.request();
                    }
                });
                this.addIndex(new FixedContainerElement("on", 0, 0){

                    @Override
                    public void addElements() {
                        this.addElement(new MaxScaledImageElement("off", StandardThemeAssets.TEX_VANILLA_SIDE_CONFIG_ICON_ENA, 8, 8), SidedConfigContainerElement.this.buttonX + 2, SidedConfigContainerElement.this.buttonY + 2);
                        if (SidedConfigContainerElement.this.tile instanceof ISidedConfigurable) {
                            ISidedConfigurable isc = (ISidedConfigurable)SidedConfigContainerElement.this.tile;
                            Optional<SidedConfigWL> inv = isc.getSidedConfigCopy(ISidedConfigurable.ConfigType.ITEM);
                            Optional<SidedConfigWL> fluid = isc.getSidedConfigCopy(ISidedConfigurable.ConfigType.FLUID);
                            Optional<SidedConfigWL> energy = isc.getSidedConfigCopy(ISidedConfigurable.ConfigType.ENERGY);
                            if (inv.isPresent()) {
                                SidedConfigContainerElement.this.invConfig = new SlotConfigArrayElement("inv", inv.get(), SidedConfigContainerElement.this.container, SidedConfigContainerElement.this::getSizeX, SidedConfigContainerElement.this::getSizeY);
                                this.addElement(SidedConfigContainerElement.this.invConfig, -1, -1);
                            }
                            if (fluid.isPresent()) {
                                // empty if block
                            }
                            if (energy.isPresent()) {
                                // empty if block
                            }
                        }
                    }

                    @Override
                    public int getSizeX() {
                        return SidedConfigContainerElement.this.gx.request();
                    }

                    @Override
                    public int getSizeY() {
                        return SidedConfigContainerElement.this.gy.request();
                    }
                });
            }
        };
        this.addElement(this.mode, 0, 0);
    }

    @Override
    public int getSizeX() {
        return this.gx.request();
    }

    @Override
    public int getSizeY() {
        return this.gy.request();
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        if (this.configure.equals(element)) {
            if (this.mode.getNumberIndex() == 0) {
                this.mode.setIndex(1);
                this.enableConfig();
            } else {
                this.disableConfig();
                this.mode.setIndex(0);
            }
        }
        super.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void enableConfig() {
        if (this.invConfig != null) {
            this.invConfig.enableConfig();
        }
    }

    public void updateConfig(ISidedConfigurable.ConfigType type, SidedConfigWL config) {
    }

    @Override
    public void disableConfig() {
        if (this.invConfig != null) {
            this.invConfig.disableConfig();
        }
        CompoundNBT nbt = new CompoundNBT();
        if (this.invConfig != null) {
            this.invConfig.savePacketData(nbt);
        }
        if (this.tankConfig != null) {
            // empty if block
        }
        VLib.NETWORK_HANDLER.sendToServer(new SidedConfigPacket(this.tile.func_174877_v(), nbt));
    }
}

