/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig;

import com.valkyrieofnight.vlib.core.obj.container.config.SidedConfigWL;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.SequenceButton;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.image.ImageElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GridAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.StyleUtil;
import com.valkyrieofnight.vlib.core.util.client.LangUtil;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SlotConfigElement
extends FixedContainerElement {
    protected AssetID slotDisabled;
    protected AssetID slotEnabled;
    protected AssetID selection;
    protected SequenceButton back;
    protected SequenceButton top;
    protected SequenceButton left;
    protected SequenceButton front;
    protected SequenceButton right;
    protected SequenceButton bottom;
    protected final int slot;
    protected SidedConfigWL config;

    public SlotConfigElement(String id, SidedConfigWL config, int slot, AssetID slotEnabled, AssetID slotDisabled, AssetID selection) {
        super(id, 18, 18);
        this.slot = slot;
        this.config = config;
        this.slotEnabled = slotEnabled;
        this.slotDisabled = slotDisabled;
        this.selection = selection;
    }

    private SequenceButton createButton(String name, final RelativeDirection rd) {
        return new SequenceButton(name, 6, 6, 6, 6, new AssetID[]{this.slotEnabled, this.slotDisabled}){

            @Override
            public void addElements() {
                this.addElementHover(new ImageElement("img", SlotConfigElement.this.selection, StandardThemeAssets.COL_DEFAULT_IMAGE_COLOR), 0, 0);
                this.addElementFocused(new ImageElement("img", SlotConfigElement.this.selection, StandardThemeAssets.COL_DEFAULT_IMAGE_COLOR), 0, 0);
            }

            @Override
            public void initContainer() {
                super.initContainer();
                this.setIndex(SlotConfigElement.this.getImageIndex(rd));
            }
        };
    }

    private int getImageIndex(RelativeDirection rd) {
        return this.config.isEnabled(this.slot, rd) ? 0 : 1;
    }

    @Override
    public void addElements() {
        List<RelativeDirection> disabledDirections = this.config.getDisabledDirections();
        GridAlignment grid = new GridAlignment(6, 6, 0, 0, 3, Alignment.HORIZONTAL);
        if (!disabledDirections.contains((Object)RelativeDirection.BACKWARD)) {
            this.back = this.createButton("back", RelativeDirection.BACKWARD);
            this.addElement(this.back, grid.getXOffset(0), grid.getYOffset(0));
            this.back.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.back")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)));
        }
        if (!disabledDirections.contains((Object)RelativeDirection.UP)) {
            this.top = this.createButton("top", RelativeDirection.UP);
            this.addElement(this.top, grid.getXOffset(1), grid.getYOffset(0));
            this.top.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.top")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)));
        }
        if (!disabledDirections.contains((Object)RelativeDirection.LEFT)) {
            this.left = this.createButton("left", RelativeDirection.LEFT);
            this.addElement(this.left, grid.getXOffset(0), grid.getYOffset(1));
            this.left.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.left")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)));
        }
        if (!disabledDirections.contains((Object)RelativeDirection.FORWARD)) {
            this.front = this.createButton("front", RelativeDirection.FORWARD);
            this.addElement(this.front, grid.getXOffset(1), grid.getYOffset(1));
            this.front.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.front")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)));
        }
        if (!disabledDirections.contains((Object)RelativeDirection.RIGHT)) {
            this.right = this.createButton("right", RelativeDirection.RIGHT);
            this.addElement(this.right, grid.getXOffset(2), grid.getYOffset(1));
            this.right.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.right")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)));
        }
        if (!disabledDirections.contains((Object)RelativeDirection.DOWN)) {
            this.bottom = this.createButton("bottom", RelativeDirection.DOWN);
            this.addElement(this.bottom, grid.getXOffset(1), grid.getYOffset(2));
            this.bottom.addToolTip((ITextComponent)new StringTextComponent(LangUtil.toLoc("label.valkyrielib.button.bottom")).func_230530_a_(StyleUtil.create(Color4.DARK_GREEN)));
        }
    }

    @Override
    public void update() {
        if (this.config.cleanIfDirty()) {
            if (this.back != null) {
                this.back.setIndex(this.config.isEnabled(this.slot, RelativeDirection.BACKWARD) ? 0 : 1);
            }
            if (this.top != null) {
                this.top.setIndex(this.config.isEnabled(this.slot, RelativeDirection.UP) ? 0 : 1);
            }
            if (this.left != null) {
                this.left.setIndex(this.config.isEnabled(this.slot, RelativeDirection.LEFT) ? 0 : 1);
            }
            if (this.front != null) {
                this.front.setIndex(this.config.isEnabled(this.slot, RelativeDirection.FORWARD) ? 0 : 1);
            }
            if (this.right != null) {
                this.right.setIndex(this.config.isEnabled(this.slot, RelativeDirection.RIGHT) ? 0 : 1);
            }
            if (this.bottom != null) {
                this.bottom.setIndex(this.config.isEnabled(this.slot, RelativeDirection.DOWN) ? 0 : 1);
            }
        }
        super.update();
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        if (element == null) {
            return;
        }
        if (element.equals(this.back)) {
            if (this.back.getIndex() == 0) {
                this.config.enableDirection(this.slot, RelativeDirection.BACKWARD);
            } else {
                this.config.disableDirection(this.slot, RelativeDirection.BACKWARD);
            }
        } else if (element.equals(this.top)) {
            if (this.top.getIndex() == 0) {
                this.config.enableDirection(this.slot, RelativeDirection.UP);
            } else {
                this.config.disableDirection(this.slot, RelativeDirection.UP);
            }
        } else if (element.equals(this.left)) {
            if (this.left.getIndex() == 0) {
                this.config.enableDirection(this.slot, RelativeDirection.LEFT);
            } else {
                this.config.disableDirection(this.slot, RelativeDirection.LEFT);
            }
        } else if (element.equals(this.front)) {
            if (this.front.getIndex() == 0) {
                this.config.enableDirection(this.slot, RelativeDirection.FORWARD);
            } else {
                this.config.disableDirection(this.slot, RelativeDirection.FORWARD);
            }
        } else if (element.equals(this.right)) {
            if (this.right.getIndex() == 0) {
                this.config.enableDirection(this.slot, RelativeDirection.RIGHT);
            } else {
                this.config.disableDirection(this.slot, RelativeDirection.RIGHT);
            }
        } else if (element.equals(this.bottom)) {
            if (this.bottom.getIndex() == 0) {
                this.config.enableDirection(this.slot, RelativeDirection.DOWN);
            } else {
                this.config.disableDirection(this.slot, RelativeDirection.DOWN);
            }
        }
    }
}

