/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import java.util.concurrent.ConcurrentMap;

public class Theme {
    protected final ThemeID id;
    protected final ThemeRegistryClient reg;
    protected volatile ConcurrentMap<AssetID, GuiSizableBox> boxMap = Maps.newConcurrentMap();
    protected volatile ConcurrentMap<AssetID, Color4> colorMap = Maps.newConcurrentMap();
    protected volatile ConcurrentMap<AssetID, GuiTexture> textureMap = Maps.newConcurrentMap();

    protected Theme(ThemeID id, ThemeRegistryClient reg) {
        this.id = id;
        this.reg = reg;
    }

    public synchronized GuiSizableBox getSizableBox(AssetID id) {
        GuiSizableBox r = (GuiSizableBox)this.boxMap.get(id);
        return r != null ? r : this.reg.getDefault().getSizableBox(id);
    }

    public synchronized Color4 getColor(AssetID id) {
        Color4 r = (Color4)this.colorMap.get(id);
        return r != null ? r : this.reg.getDefault().getColor(id);
    }

    public synchronized GuiTexture getTexture(AssetID id) {
        GuiTexture r = (GuiTexture)this.textureMap.get(id);
        return r != null ? r : this.reg.getDefault().getTexture(id);
    }

    protected void registerTexture(AssetID id, GuiTexture texture) {
        this.textureMap.computeIfAbsent(id, v -> texture);
    }

    protected void registerColor(AssetID id, Color4 color4) {
        this.colorMap.computeIfAbsent(id, v -> color4);
    }

    protected void registerSizableBox(AssetID id, GuiSizableBox box) {
        this.boxMap.computeIfAbsent(id, v -> box);
    }
}

