/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.common;

import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ThemeRegistry {
    public static final ThemeID DEFAULT = new ThemeID("default", "default");
    public static final ThemeID DARK = new ThemeID("valkyrielib", "dark");
    protected Map<ThemeID, Boolean> allThemeIDs = new ConcurrentHashMap<ThemeID, Boolean>();

    protected ThemeRegistry() {
    }

    public boolean contains(ThemeID themeID) {
        return themeID != null ? this.allThemeIDs.containsKey(themeID) : false;
    }

    public final void registerTheme(ThemeID theme) {
        if (theme == null) {
            return;
        }
        this.allThemeIDs.computeIfAbsent(theme, v -> true);
        this.onThemeCreated(theme);
    }

    protected abstract void onThemeCreated(ThemeID var1);

    protected Set<ThemeID> getAllThemes() {
        return this.allThemeIDs.keySet();
    }
}

